/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskadmin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.Document;
import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Legend;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;

@Dependent
@Templated(value="TaskAdminViewImpl.html")
public class TaskAdminViewImpl
extends Composite
implements TaskAdminPresenter.TaskAdminView {
    @Inject
    @DataField
    public Legend adminDetailsAccordionLabel;
    @Inject
    @DataField
    public FormLabel adminUserOrGroupLabel;
    @Inject
    @DataField
    public FormLabel adminUsersGroupsControlsLabel;
    @Inject
    @DataField
    public TextBox adminUserOrGroupText;
    @Inject
    @DataField
    public Button adminForwardButton;
    @Inject
    @DataField
    public HTMLUListElement adminUsersGroupsControlsPanel;
    @Inject
    @DataField
    public Legend reminderDetailsAccordionLabel;
    @Inject
    @DataField
    public FormLabel actualOwnerLabel;
    @Inject
    @DataField
    public FormControlStatic actualOwnerPanel;
    @Inject
    @DataField
    public Button adminReminderButton;
    @Inject
    @DataField
    private HTMLDivElement adminUserOrGroupFormGroup;
    @Inject
    @Named(value="span")
    @DataField
    private HTMLElement adminUserOrGroupHelp;
    private TaskAdminPresenter presenter;
    @Inject
    private Document document;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public void init(TaskAdminPresenter presenter) {
        this.presenter = presenter;
        this.adminUserOrGroupLabel.setText(this.constants.Delegate_User());
        this.adminDetailsAccordionLabel.setText(this.constants.Details());
        this.adminForwardButton.setText(this.constants.Forward());
        this.adminUsersGroupsControlsLabel.setText(this.constants.Potential_Owners());
        this.reminderDetailsAccordionLabel.setText(this.constants.Reminder_Details());
        this.actualOwnerLabel.setText(this.constants.Actual_Owner());
        this.adminReminderButton.setText(this.constants.Reminder());
    }

    @EventHandler(value={"adminForwardButton"})
    public void adminForwardButton(ClickEvent e) {
        String userOrGroup = this.adminUserOrGroupText.getText();
        if (!userOrGroup.equals("")) {
            this.presenter.forwardTask(userOrGroup);
            this.adminForwardButton.setEnabled(false);
        } else {
            this.adminUserOrGroupFormGroup.classList.add(new String[]{"has-error"});
            this.adminUserOrGroupHelp.textContent = this.constants.PleaseEnterUserOrAGroupToForward();
        }
    }

    @EventHandler(value={"adminReminderButton"})
    public void adminReminderButton(ClickEvent e) {
        this.presenter.reminder();
    }

    @Override
    public void setUsersGroupsControlsPanelText(List<String> text) {
        new Elemental2DomUtil().removeAllElementChildren((Node)this.adminUsersGroupsControlsPanel);
        text.forEach(t -> {
            Element li = this.document.createElement("li");
            li.textContent = t;
            this.adminUsersGroupsControlsPanel.appendChild((Node)li);
        });
    }

    @Override
    public void enableForwardButton(boolean enabled) {
        this.adminForwardButton.setEnabled(enabled);
    }

    @Override
    public void enableUserOrGroupText(boolean enabled) {
        this.adminUserOrGroupText.setEnabled(enabled);
    }

    @Override
    public void clearUserOrGroupText() {
        this.adminUserOrGroupText.setText("");
        this.adminUserOrGroupFormGroup.classList.remove(new String[]{"has-error"});
        this.adminUserOrGroupHelp.textContent = "";
    }

    @Override
    public void enableReminderButton(boolean enabled) {
        this.adminReminderButton.setEnabled(enabled);
    }

    @Override
    public void setActualOwnerText(String actualOwnerText) {
        this.actualOwnerPanel.setText(actualOwnerText);
    }
}

