/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import com.google.gwt.user.client.ui.IsWidget;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class TaskLogsPresenter
extends AbstractTaskPresenter {
    public static final int PAGE_SIZE = 10;
    private int currentPage = 0;
    private List<TaskEventSummary> visibleLogs = new ArrayList<TaskEventSummary>();
    private TaskLogsView view;
    private Caller<TaskService> taskService;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Inject
    public TaskLogsPresenter(TaskLogsView view, Caller<TaskService> taskService) {
        this.view = view;
        this.taskService = taskService;
    }

    public int getPageSize() {
        return 10;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    public IsWidget getView() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void refreshLogs() {
        this.currentPage = 0;
        this.loadTaskLogs();
    }

    public void loadTaskLogs() {
        ((TaskService)this.taskService.call(events -> {
            if (this.currentPage == 0) {
                this.visibleLogs = new ArrayList<TaskEventSummary>();
            }
            this.visibleLogs.addAll((Collection<TaskEventSummary>)events);
            this.view.hideLoadButton(events.size() < 10);
            this.view.setLogs(this.visibleLogs.stream().collect(Collectors.toList()));
        })).getTaskEvents(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), Integer.valueOf(this.currentPage), Integer.valueOf(this.getPageSize()));
    }

    public void loadMoreProcessInstanceLogs() {
        this.setCurrentPage(this.currentPage + 1);
        this.loadTaskLogs();
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.setSelectedTask(event);
        this.refreshLogs();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            this.refreshLogs();
        }
    }

    public static interface TaskLogsView
    extends UberElemental<TaskLogsPresenter> {
        public void setLogs(List<TaskEventSummary> var1);

        public void hideLoadButton(boolean var1);
    }
}

