/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogItemView;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskLogItemViewTest {
    @Mock
    private Constants constants;
    @Mock
    private Span logTime;
    @Mock
    protected Span logInfo;
    @Mock
    protected Span logIcon;
    @Mock
    protected Span logTypeDesc;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataBinder<TaskEventSummary> logSummary;
    @InjectMocks
    private TaskLogItemView view;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.constants.Task()).thenReturn((Object)"Task");
        Mockito.when((Object)this.constants.ByUser()).thenReturn((Object)"by user");
        Mockito.when((Object)this.constants.ByProcess()).thenReturn((Object)"by process");
        Mockito.when((Object)this.constants.TaskOwnerLogInfo(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)"by user Jan to user Cory");
        Mockito.when((Object)this.translationService.format((String)Matchers.any(), new Object[0])).then(i -> i.getArgument(0, String.class));
    }

    @Test
    public void testStoppedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(2L), Long.valueOf(1L), "STOPPED", "Maria", Long.valueOf(3L), Date.from(LocalDateTime.of(2018, 12, 5, 17, 15).atZone(ZoneId.systemDefault()).toInstant()), "Maria stopped this task", "");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "05/12/2018 17:15");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task stopped");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs kie-timeline-icon--completed");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user Maria");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task stopped");
    }

    @Test
    public void testUpdatedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(2L), Long.valueOf(2L), "UPDATED", "Maria", Long.valueOf(3L), this.createDate(2016, 2, 5, 15, 2), "Maria updated this task", "");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "05/02/2016 15:02");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task updated");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user Maria (Maria updated this task)");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task updated");
    }

    @Test
    public void testClaimedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(3L), Long.valueOf(5L), "CLAIMED", "John", Long.valueOf(3L), this.createDate(2018, 1, 20, 5, 30), "John claimed this task", "");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "20/01/2018 05:30");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task claimed");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user John");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task claimed");
    }

    @Test
    public void testDelegatedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(1L), Long.valueOf(3L), "DELEGATED", "Jan", Long.valueOf(3L), this.createDate(2017, 12, 15, 15, 0), "Jan delegated this task", "Cory");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "15/12/2017 15:00");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task delegated");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user Jan to user Cory");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task delegated");
    }

    @Test
    public void testForwardedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(1L), Long.valueOf(3L), "FORWARDED", "Jan", Long.valueOf(3L), this.createDate(2017, 12, 15, 15, 0), "Jan forwarded this task", "Cory");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "15/12/2017 15:00");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task forwarded");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user Jan");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task forwarded");
    }

    @Test
    public void testAddedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(1L), Long.valueOf(1L), "ADDED", "exampleProcess", Long.valueOf(3L), this.createDate(2017, 12, 15, 4, 59), "exampleProcess added this task", "");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "15/12/2017 04:59");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task added");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by process 'exampleProcess'");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task added");
    }

    @Test
    public void testCompletedTask() {
        TaskEventSummary model = new TaskEventSummary(Long.valueOf(1L), Long.valueOf(3L), "COMPLETED", "Andrew", Long.valueOf(3L), this.createDate(2018, 12, 11, 0, 15), "Andrew completed this task", "");
        this.view.setValue(model);
        ((DataBinder)Mockito.verify(this.logSummary)).setModel((Object)model);
        ((Span)Mockito.verify((Object)this.logTime)).setAttribute("data-original-title", "11/12/2018 00:15");
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Task completed");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user kie-timeline-icon--completed");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("by user Andrew");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task completed");
    }

    private Date createDate(int year, int month, int dayOfMonth, int hour, int minute) {
        return Date.from(LocalDateTime.of(year, month, dayOfMonth, hour, minute).atZone(ZoneId.systemDefault()).toInstant());
    }
}

