/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.ht.client.editors.taskslist.popup.TasksReassignmentPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.ValidationState;

@Dependent
@Templated(value="TasksReassignmentViewImpl.html")
public class TasksReassignmentViewImpl
extends Composite
implements TasksReassignmentPresenter.TasksReassignmentView {
    @Inject
    @DataField
    public Button reassignButton;
    @Inject
    @DataField
    public Button clearButton;
    @Inject
    @DataField
    public FormLabel userIdLabel;
    @Inject
    @DataField
    public TextBox userIdInput;
    @Inject
    @DataField
    public HelpBlock userIdHelpBlock;
    @Inject
    @DataField(value="userid-input-help")
    org.jboss.errai.common.client.dom.Button userIdInputHelp;
    @Inject
    @DataField
    private FormGroup userIdFormGroup;
    @Inject
    private JQueryProducer.JQuery<Popover> jQueryPopover;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private TasksReassignmentPresenter presenter;

    public void init(TasksReassignmentPresenter presenter) {
        this.presenter = presenter;
        this.userIdInputHelp.setAttribute("data-content", this.getInputStringHelpHtml());
        ((Popover)this.jQueryPopover.wrap((Element)this.userIdInputHelp)).popover();
        this.userIdLabel.setText(this.constants.Delegate_User());
        this.reassignButton.setText(this.constants.Delegate());
        this.clearButton.setText(this.constants.Clear());
        this.userIdLabel.setShowRequiredIndicator(true);
        this.clearFields();
    }

    private String getInputStringHelpHtml() {
        return "<p>" + this.constants.To_Reassign_Selected_Tasks_Introduce_UserId() + "</p>\n";
    }

    @EventHandler(value={"reassignButton"})
    public void reassignTasks(ClickEvent e) {
        String userOrGroup = this.userIdInput.getText();
        if (!userOrGroup.isEmpty()) {
            this.presenter.reassignTasksToUser(userOrGroup);
            this.reassignButton.setEnabled(false);
        } else {
            this.showErrorMessage(this.constants.PleaseEnterUserIdToPerformDelegation());
        }
    }

    @EventHandler(value={"clearButton"})
    public void clearButton(ClickEvent e) {
        this.clearFields();
    }

    private void clearFields() {
        this.userIdInput.setValue((Object)"");
        this.userIdHelpBlock.setText("");
        this.userIdFormGroup.clearValidationState();
    }

    public void showErrorMessage(String text) {
        this.userIdFormGroup.setValidationState(ValidationState.ERROR);
        this.userIdHelpBlock.setText(text);
    }
}

