/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.cases.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.wi.cases.service.CaseProjectService;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class CaseProjectServiceImpl
implements CaseProjectService {
    private static final Logger logger = LoggerFactory.getLogger(CaseProjectServiceImpl.class);
    protected static final String CASE_FILE_MARSHALLER = "org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();";
    protected static final String DOCUMENT_MARSHALLER = "new org.jbpm.document.marshalling.DocumentMarshallingStrategy();";
    private static final String CASE_PROJECT_DOT_FILE = ".caseproject";
    private static final String DEPLOYMENT_DESCRIPTOR_FILE = "kie-deployment-descriptor.xml";
    private static final String WORK_DEFINITION_FILE = "WorkDefinition.wid";
    private static final String CASE_WORK_DEFINITION_FILE = "/CaseWorkDefinitions.wid";
    private IOService ioService;
    private DDEditorService ddEditorService;
    private List<String> noWIDDirectories = Arrays.asList("META-INF");

    public CaseProjectServiceImpl() {
    }

    @Inject
    public CaseProjectServiceImpl(DDEditorService ddEditorService, @Named(value="ioStrategy") IOService ioService) {
        this.ddEditorService = ddEditorService;
        this.ioService = ioService;
    }

    public void configureNewCaseProject(Project project) {
        logger.debug("configuring case project {}", (Object)project);
        KieProject kieProject = (KieProject)project;
        String separator = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()).getFileSystem().getSeparator();
        String rootPathString = project.getRootPath().toURI().toString() + separator + CASE_PROJECT_DOT_FILE;
        Path rootPath = this.ioService.get(URI.create(rootPathString));
        this.ioService.write(rootPath, "", new OpenOption[0]);
        logger.debug("Added caseproject marker (dot) file at {}", (Object)rootPath);
        String metaInfPath = Paths.convert((org.uberfire.backend.vfs.Path)kieProject.getKModuleXMLPath()).getParent().toUri().toString();
        String deploymentDescriptorPath = metaInfPath + separator + DEPLOYMENT_DESCRIPTOR_FILE;
        Path ddVFSPath = this.ioService.get(URI.create(deploymentDescriptorPath));
        org.uberfire.backend.vfs.Path convertedDDVFSPath = Paths.convert((Path)ddVFSPath);
        if (!this.ioService.exists(ddVFSPath)) {
            this.ddEditorService.createIfNotExists(convertedDDVFSPath);
            logger.debug("Created deployment descriptor in {}", (Object)convertedDDVFSPath);
        }
        logger.debug("Loading deployment descriptor from {}", (Object)convertedDDVFSPath);
        DeploymentDescriptorModel descriptorModel = (DeploymentDescriptorModel)this.ddEditorService.load(convertedDDVFSPath);
        descriptorModel.setRuntimeStrategy("PER_CASE");
        ArrayList<ItemObjectModel> modelList = descriptorModel.getMarshallingStrategies();
        if (modelList == null) {
            modelList = new ArrayList<ItemObjectModel>();
        }
        modelList.add(new ItemObjectModel(null, CASE_FILE_MARSHALLER, "mvel", new ArrayList()));
        modelList.add(new ItemObjectModel(null, DOCUMENT_MARSHALLER, "mvel", new ArrayList()));
        descriptorModel.setMarshallingStrategies(modelList);
        logger.debug("Deployment descriptor model updated with case information {}", (Object)descriptorModel);
        this.ddEditorService.save(convertedDDVFSPath, (Object)descriptorModel, null, "Updated with case project configuration");
        logger.debug("Updated deployment model saved");
        String resourcesPathStr = Paths.convert((org.uberfire.backend.vfs.Path)kieProject.getKModuleXMLPath()).getParent().getParent().toUri().toString();
        Path widFilePath = this.ioService.get(URI.create(resourcesPathStr + separator + WORK_DEFINITION_FILE));
        logger.debug("Adding WorkDefinition.wid file to resources folder {} of the project {}", (Object)widFilePath, (Object)project);
        this.addWorkDefinitions(widFilePath);
        logger.debug("Adding WorkDefinition.wid to all packages...");
        this.addWorkDefinitionsRecursively(widFilePath.getParent(), separator);
    }

    public void configurePackage(@Observes NewPackageEvent pkg) {
        if (this.isCaseProject(Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackage().getProjectRootPath()))) {
            String resourcesPathStr = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackage().getPackageMainResourcesPath()).toUri().toString();
            String separator = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackage().getProjectRootPath()).getFileSystem().getSeparator();
            Path resourcesPath = this.ioService.get(URI.create(resourcesPathStr + separator + WORK_DEFINITION_FILE));
            this.addWorkDefinitions(resourcesPath);
        }
    }

    protected void addWorkDefinitionsRecursively(Path startAt, String separator) {
        DirectoryStream directoryStream = this.ioService.newDirectoryStream(startAt, path -> Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0]) && !this.noWIDDirectories.contains(path.getFileName().toString()));
        for (Path current : directoryStream) {
            Path widFilePath = this.ioService.get(URI.create(current.toUri() + separator + WORK_DEFINITION_FILE));
            this.addWorkDefinitions(widFilePath);
            this.addWorkDefinitionsRecursively(current, separator);
        }
    }

    protected void addWorkDefinitions(Path location) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(CASE_WORK_DEFINITION_FILE));
            this.ioService.write(location, data, new OpenOption[0]);
            logger.debug("WorkDefinition.wid file added to {}", (Object)location);
        }
        catch (IOException e) {
            logger.error("Error when writing WorkDefinition.wid file in {}", (Object)location, (Object)e);
        }
    }

    protected boolean isCaseProject(Path rootProjectPath) {
        DirectoryStream found = this.ioService.newDirectoryStream(rootProjectPath, f -> f.endsWith(CASE_PROJECT_DOT_FILE));
        return found.iterator().hasNext();
    }
}

