/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.jbpm.workbench.wi.backend.server.casemgmt.service.CaseProvisioningExecutor;
import org.jbpm.workbench.wi.backend.server.casemgmt.service.CaseProvisioningServiceImpl;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningCompletedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningFailedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningStartedEvent;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningSettings;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseProvisioningServiceImplTest {
    @Mock
    private CaseProvisioningExecutor executor;
    @Mock
    private CaseProvisioningSettings settings;
    @InjectMocks
    private CaseProvisioningServiceImpl service;

    @Test
    public void testProvisioningDisabled() {
        Mockito.when((Object)this.settings.isProvisioningEnabled()).thenReturn((Object)false);
        this.service.init();
        ((CaseProvisioningExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).execute((PipelineExecutor)Mockito.any(PipelineExecutor.class), (Pipeline)Mockito.any(Pipeline.class), (Input)Mockito.any(Input.class));
        Assert.assertEquals((Object)CaseProvisioningStatus.DISABLED, (Object)this.service.getProvisioningStatus());
    }

    @Test
    public void testProvisioningUsingWarPath() {
        String path = "path/to/file.war";
        Mockito.when((Object)this.settings.isProvisioningEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.settings.isDeployFromLocalPath()).thenReturn((Object)true);
        Mockito.when((Object)this.settings.getPath()).thenReturn((Object)"path/to/file.war");
        this.service.init();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Input.class);
        ((CaseProvisioningExecutor)Mockito.verify((Object)this.executor)).execute((PipelineExecutor)Mockito.any(PipelineExecutor.class), (Pipeline)Mockito.any(Pipeline.class), (Input)captor.capture());
        Assert.assertEquals((Object)"path/to/file.war", (Object)((Input)captor.getValue()).get((Object)"war-path"));
    }

    @Test
    public void testProvisioningUsingMaven() {
        String gav = "org.jbpm:jbpm-wb-case-mgmt-showcase:war:1.0.0";
        Mockito.when((Object)this.settings.isProvisioningEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.settings.isDeployFromLocalPath()).thenReturn((Object)false);
        Mockito.when((Object)this.settings.getGAV()).thenReturn((Object)"org.jbpm:jbpm-wb-case-mgmt-showcase:war:1.0.0");
        this.service.init();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Input.class);
        ((CaseProvisioningExecutor)Mockito.verify((Object)this.executor)).execute((PipelineExecutor)Mockito.any(PipelineExecutor.class), (Pipeline)Mockito.any(Pipeline.class), (Input)captor.capture());
        Assert.assertEquals((Object)"org.jbpm:jbpm-wb-case-mgmt-showcase:war:1.0.0", (Object)((Input)captor.getValue()).get((Object)"artifact"));
    }

    @Test
    public void testOnCaseManagementProvisioningStartedEvent() {
        this.service.onCaseManagementProvisioningStartedEvent(new CaseProvisioningStartedEvent());
        Assert.assertEquals((Object)CaseProvisioningStatus.STARTED, (Object)this.service.getProvisioningStatus());
    }

    @Test
    public void testOnCaseManagementProvisioningCompletedEvent() {
        this.service.onCaseManagementProvisioningCompletedEvent(new CaseProvisioningCompletedEvent());
        Assert.assertEquals((Object)CaseProvisioningStatus.COMPLETED, (Object)this.service.getProvisioningStatus());
    }

    @Test
    public void testOnCaseManagementProvisioningFailedEvent() {
        this.service.onCaseManagementProvisioningFailedEvent(new CaseProvisioningFailedEvent());
        Assert.assertEquals((Object)CaseProvisioningStatus.FAILED, (Object)this.service.getProvisioningStatus());
    }
}

