/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.process.workitem.repository.storage.InMemoryRepositoryStorage;
import org.jbpm.workbench.wi.backend.server.workitem.ServiceTaskUtils;
import org.jbpm.workbench.wi.workitems.model.ServiceTasksConfiguration;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Named(value="serviceTasksStorageVFS")
@ApplicationScoped
public class RepositoryStorageVFSImpl
extends InMemoryRepositoryStorage<ServiceTasksConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryStorageVFSImpl.class);
    private IOService ioService;
    private FileSystem fileSystem;
    private XStream xs = XStreamUtils.createTrustingXStream();
    private Path storagePath;
    private Path configPath;
    private ServiceTasksConfiguration configuration;

    public RepositoryStorageVFSImpl() {
    }

    @Inject
    public RepositoryStorageVFSImpl(@Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem fileSystem) {
        this();
        this.ioService = ioService;
        this.fileSystem = fileSystem;
    }

    @PostConstruct
    public void init() {
        this.configPath = this.fileSystem.getPath("service-tasks", new String[]{"remote", "service-repository-config.xml"});
        if (this.ioService.exists(this.configPath)) {
            try {
                this.ioService.startBatch(this.configPath.getFileSystem());
                this.configuration = (ServiceTasksConfiguration)this.xs.fromXML(this.ioService.readAllString(this.configPath));
            }
            finally {
                this.ioService.endBatch();
            }
        } else {
            this.configuration = new ServiceTasksConfiguration(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
        this.storagePath = this.fileSystem.getPath("service-tasks", new String[]{"remote", "service-repository-storage.xml"});
        if (this.ioService.exists(this.storagePath)) {
            try {
                this.ioService.startBatch(this.storagePath.getFileSystem());
                this.services = (List)this.xs.fromXML(this.ioService.readAllString(this.storagePath));
            }
            finally {
                this.ioService.endBatch();
            }
            logger.debug("Loaded all known service tasks from the storage (size {})", (Object)this.services.size());
        } else {
            this.services = new ArrayList();
            logger.debug("Service tasks not found in storage ");
        }
    }

    public List<RepoData> synchronizeServices(List<RepoData> currentServices) {
        if (!currentServices.isEmpty()) {
            for (RepoData service : currentServices) {
                this.enforceId(service);
                if (this.services.contains(service)) continue;
                if (!ServiceTaskUtils.DEFAULT_HANDLERS.contains(service.getModule())) {
                    service.setEnabled(false);
                }
                this.services.add(service);
            }
        }
        this.store(this.storagePath, this.services);
        return this.services;
    }

    public void onAdded(RepoData service) {
        this.enforceId(service);
        this.store(this.storagePath, this.services);
    }

    public void onEnabled(RepoData service) {
        this.store(this.storagePath, this.services);
    }

    public void onDisabled(RepoData service) {
        this.store(this.storagePath, this.services);
    }

    public void onInstalled(RepoData service, String target) {
        this.store(this.storagePath, this.services);
    }

    public void onUninstalled(RepoData service, String target) {
        this.store(this.storagePath, this.services);
    }

    public ServiceTasksConfiguration loadConfiguration() {
        return this.configuration;
    }

    public void storeConfiguration(ServiceTasksConfiguration configuration) {
        this.store(this.configPath, configuration);
        this.configuration = configuration;
    }

    public void onProjectDeleted(@Observes RepositoryRemovedEvent deletedEvent) {
        String target = ServiceTaskUtils.extractTargetInfo(deletedEvent.getRepository().getUri());
        logger.debug("{} has been removed, removing any references to it on service tasks", (Object)target);
        this.services.stream().filter(service -> service.getInstalledOn().contains(target)).forEach(service -> {
            service.uninstall(target);
            logger.debug("Service {} uninstalled from deleted target {}", (Object)service.getName(), (Object)target);
        });
    }

    protected void store(Path path, Object data) {
        try {
            this.ioService.startBatch(this.fileSystem);
            this.ioService.write(path, this.xs.toXML(data), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

