/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.dd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorIO;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorImpl;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorManager {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorManager.class);
    private String defaultPU = "org.jbpm.persistence.jpa";

    public DeploymentDescriptorManager() {
    }

    public DeploymentDescriptorManager(String defaultPU) {
        this.defaultPU = defaultPU;
    }

    public DeploymentDescriptor getDefaultDescriptor() {
        DeploymentDescriptorImpl defaultDesc = null;
        URL defaultDescriptorLocation = this.getDefaultdescriptorlocation();
        if (defaultDescriptorLocation != null) {
            try {
                logger.debug("Reading default descriptor from " + defaultDescriptorLocation);
                defaultDesc = DeploymentDescriptorIO.fromXml(defaultDescriptorLocation.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read default deployment descriptor from " + defaultDescriptorLocation, e);
            }
        } else {
            logger.debug("No descriptor found returning default instance");
            defaultDesc = new DeploymentDescriptorImpl(this.defaultPU);
        }
        return defaultDesc;
    }

    public List<DeploymentDescriptor> getDeploymentDescriptorHierarchy(KieContainer kieContainer) {
        ArrayList<DeploymentDescriptor> descriptorHierarchy = new ArrayList<DeploymentDescriptor>();
        InternalKieModule module = ((KieModuleKieProject)((KieContainerImpl)kieContainer).getKieProject()).getInternalKieModule();
        this.collectDeploymentDescriptors(module, descriptorHierarchy);
        descriptorHierarchy.add(this.getDefaultDescriptor());
        return descriptorHierarchy;
    }

    protected URL getDefaultdescriptorlocation() {
        URL locationUrl;
        block6: {
            String defaultDescriptorLocation = System.getProperty("org.kie.deployment.desc.location");
            locationUrl = null;
            if (defaultDescriptorLocation != null) {
                if (defaultDescriptorLocation.startsWith("classpath:")) {
                    String stripedLocation = defaultDescriptorLocation.replaceFirst("classpath:", "");
                    locationUrl = this.getClass().getResource(stripedLocation);
                    if (locationUrl == null) {
                        locationUrl = Thread.currentThread().getContextClassLoader().getResource(stripedLocation);
                    }
                } else {
                    try {
                        locationUrl = new URL(defaultDescriptorLocation);
                    }
                    catch (MalformedURLException e) {
                        locationUrl = this.getClass().getResource(defaultDescriptorLocation);
                        if (locationUrl != null) break block6;
                        locationUrl = Thread.currentThread().getContextClassLoader().getResource(defaultDescriptorLocation);
                    }
                }
            }
        }
        return locationUrl;
    }

    protected void collectDeploymentDescriptors(InternalKieModule kmodule, List<DeploymentDescriptor> descriptorHierarchy) {
        DeploymentDescriptor descriptor = this.getDescriptorFromKModule(kmodule);
        if (descriptor != null) {
            descriptorHierarchy.add(descriptor);
        }
        if (kmodule.getKieDependencies() != null) {
            Collection depModules = kmodule.getKieDependencies().values();
            for (InternalKieModule depModule : depModules) {
                this.collectDeploymentDescriptors(depModule, descriptorHierarchy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeploymentDescriptor getDescriptorFromKModule(InternalKieModule kmodule) {
        DeploymentDescriptor desc = null;
        if (kmodule.isAvailable("META-INF/kie-deployment-descriptor.xml")) {
            byte[] content = kmodule.getBytes("META-INF/kie-deployment-descriptor.xml");
            ByteArrayInputStream input = new ByteArrayInputStream(content);
            try {
                desc = DeploymentDescriptorIO.fromXml(input);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.debug("Error when closing stream of kie-deployment-descriptor.xml");
                }
            }
        }
        return desc;
    }
}

