/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.wi.casemgmt.service.CaseProjectService;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@Service
@ApplicationScoped
public class CaseProjectServiceImpl
implements CaseProjectService {
    protected static final String CASE_FILE_MARSHALLER = "org.jbpm.casemgmt.impl.marshalling.CaseMarshallerFactory.builder().withDoc().get();";
    protected static final String DOCUMENT_MARSHALLER = "new org.jbpm.document.marshalling.DocumentMarshallingStrategy();";
    protected static final String START_CASE_HANDLER = "new org.jbpm.casemgmt.impl.wih.StartCaseWorkItemHandler(ksession);";
    protected static final String START_CASE_WORK_ITEM = "StartCaseInstance";
    private static final Logger logger = LoggerFactory.getLogger(CaseProjectServiceImpl.class);
    private static final String CASE_PROJECT_DOT_FILE = ".caseproject";
    private static final String DEPLOYMENT_DESCRIPTOR_FILE = "kie-deployment-descriptor.xml";
    private static final String WORK_DEFINITION_FILE = "WorkDefinition.wid";
    private static final String GLOBAL_DIRECTORY = "global";
    private static final String BUSINESS_RULE_TASK_ICON = "defaultbusinessruletaskicon.png";
    private static final String EMAIL_ICON = "defaultemailicon.png";
    private static final String DECISION_TASKICON = "defaultdecisiontaskicon.png";
    private static final String LOG_ICON = "defaultlogicon.png";
    private static final String MILESTONE_ICON = "defaultmilestoneicon.png";
    private static final String SERVICE_ICON = "defaultservicenodeicon.png";
    private static final String REST_ICON = "defaultresticon.png";
    private static final String WEB_SERVICE_ICON = "defaultwebserviceicon.png";
    private IOService ioService;
    private DDEditorService ddEditorService;

    public CaseProjectServiceImpl() {
    }

    @Inject
    public CaseProjectServiceImpl(DDEditorService ddEditorService, @Named(value="ioStrategy") IOService ioService) {
        this.ddEditorService = ddEditorService;
        this.ioService = ioService;
    }

    public void configureNewCaseProject(WorkspaceProject project) {
        logger.debug("configuring case project {}", (Object)project);
        KieModule kieModule = (KieModule)project.getMainModule();
        org.uberfire.backend.vfs.Path rootPath1 = project.getRootPath();
        String separator = Paths.convert((org.uberfire.backend.vfs.Path)rootPath1).getFileSystem().getSeparator();
        try {
            String caseProjectDotFilePathStr = project.getMainModule().getRootPath().toURI().toString() + CASE_PROJECT_DOT_FILE;
            Path caseProjectDotFilePath = this.ioService.get(new URI(caseProjectDotFilePathStr));
            if (!this.ioService.exists(caseProjectDotFilePath)) {
                this.ioService.write(caseProjectDotFilePath, "", new OpenOption[0]);
                logger.debug("Added caseproject marker (dot) file at {}", (Object)caseProjectDotFilePath);
            } else {
                logger.debug("Caseproject marker (dot) file already exists. Not adding it.");
            }
        }
        catch (Exception e) {
            logger.error("Unable to write caseproject marker (dot) file: {}", (Object)e.getMessage());
        }
        String metaInfPath = Paths.convert((org.uberfire.backend.vfs.Path)kieModule.getKModuleXMLPath()).getParent().toUri().toString();
        String deploymentDescriptorPath = metaInfPath + separator + DEPLOYMENT_DESCRIPTOR_FILE;
        Path ddVFSPath = this.ioService.get(URI.create(deploymentDescriptorPath));
        org.uberfire.backend.vfs.Path convertedDDVFSPath = Paths.convert((Path)ddVFSPath);
        if (!this.ioService.exists(ddVFSPath)) {
            this.ddEditorService.createIfNotExists(convertedDDVFSPath);
            logger.debug("Created deployment descriptor in {}", (Object)convertedDDVFSPath);
        }
        logger.debug("Loading deployment descriptor from {}", (Object)convertedDDVFSPath);
        DeploymentDescriptorModel descriptorModel = (DeploymentDescriptorModel)this.ddEditorService.load(convertedDDVFSPath);
        descriptorModel.setRuntimeStrategy("PER_CASE");
        ArrayList<ItemObjectModel> modelList = descriptorModel.getMarshallingStrategies();
        if (modelList == null) {
            modelList = new ArrayList<ItemObjectModel>();
        }
        modelList.add(new ItemObjectModel(null, CASE_FILE_MARSHALLER, "mvel", new ArrayList()));
        modelList.add(new ItemObjectModel(null, DOCUMENT_MARSHALLER, "mvel", new ArrayList()));
        descriptorModel.setMarshallingStrategies(modelList);
        ArrayList<ItemObjectModel> wiModelList = descriptorModel.getWorkItemHandlers();
        if (wiModelList == null) {
            wiModelList = new ArrayList<ItemObjectModel>();
        }
        wiModelList.add(new ItemObjectModel(START_CASE_WORK_ITEM, START_CASE_HANDLER, "mvel", new ArrayList()));
        descriptorModel.setWorkItemHandlers(wiModelList);
        Path globalPath = Paths.convert((org.uberfire.backend.vfs.Path)kieModule.getKModuleXMLPath()).getRoot().resolve(GLOBAL_DIRECTORY);
        if (this.ioService.notExists(globalPath)) {
            this.ioService.createDirectory(globalPath, new FileAttribute[0]);
        }
        logger.debug("Deployment descriptor model updated with case information {}", (Object)descriptorModel);
        this.ddEditorService.save(convertedDDVFSPath, (Object)descriptorModel, null, "Updated with case project configuration");
        logger.debug("Updated deployment model saved");
        logger.debug("Adding WorkDefinition.wid file to resources folder {} of the project {}", (Object)globalPath, (Object)project);
        this.addWorkDefinitions(kieModule, separator);
        logger.debug("Default WorkItemDefinitions added to {}", (Object)globalPath.toString());
    }

    protected void addWorkDefinitions(KieModule kieModule, String separator) {
        String globalPath = Paths.convert((org.uberfire.backend.vfs.Path)kieModule.getKModuleXMLPath()).getParent().getParent().getParent().getParent().getParent().toUri().toString() + GLOBAL_DIRECTORY;
        this.writeFile(globalPath, separator, WORK_DEFINITION_FILE);
        this.writeFile(globalPath, separator, BUSINESS_RULE_TASK_ICON);
        this.writeFile(globalPath, separator, EMAIL_ICON);
        this.writeFile(globalPath, separator, DECISION_TASKICON);
        this.writeFile(globalPath, separator, LOG_ICON);
        this.writeFile(globalPath, separator, MILESTONE_ICON);
        this.writeFile(globalPath, separator, SERVICE_ICON);
        this.writeFile(globalPath, separator, REST_ICON);
        this.writeFile(globalPath, separator, WEB_SERVICE_ICON);
    }

    private void writeFile(String location, String separator, String name) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/" + name));
            Path filePath = this.ioService.get(URI.create(location + separator + name));
            this.ioService.write(filePath, data, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Error when writing WorkDefinition.wid file in {}", (Object)(location + separator + name), (Object)e);
        }
    }
}

