/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import org.jbpm.workbench.wi.backend.server.workitem.WorkbenchRepositoryEventListener;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.vfs.Path;

public class WorkbenchRepositoryEventListenerTest {
    @Test
    public void testVersionResolveNoRangeOnFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0.Final";
        String resolved = listener.resolveVersion(version, false);
        Assert.assertEquals((Object)version, (Object)resolved);
    }

    @Test
    public void testVersionResolveNoRangeOnSnapshot() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0-SNAPSHOT";
        String resolved = listener.resolveVersion(version, false);
        Assert.assertEquals((Object)version, (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0.Final";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7.16,)", (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnSnapshot() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.16.0-SNAPSHOT";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7.16,)", (Object)resolved);
    }

    @Test
    public void testVersionResolveRangeOnShortFinal() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        String version = "7.Final";
        String resolved = listener.resolveVersion(version, true);
        Assert.assertEquals((Object)"[7,)", (Object)resolved);
    }

    @Test
    public void testGetTargetPathForBranch() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        Path path = listener.getTargetPath("pom.xml", "testBranchName", "testTarget");
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"default://testBranchName@testTarget", (Object)path.toURI());
    }

    @Test
    public void testGetTargetForNullBranch() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        Path path = listener.getTargetPath("pom.xml", null, "testTarget");
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"default://master@testTarget", (Object)path.toURI());
    }

    @Test
    public void testGetTargetForEmptyBranch() {
        WorkbenchRepositoryEventListener listener = new WorkbenchRepositoryEventListener();
        Path path = listener.getTargetPath("pom.xml", "", "testTarget");
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)"default://master@testTarget", (Object)path.toURI());
    }
}

