/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class CaseDemoProvisioningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseDemoProvisioningService.class);
    @Inject
    private LibraryService libraryService;
    @Inject
    private BuildService buildService;
    @Inject
    private SpecManagementService specManagementService;
    private AtomicBoolean deployToServerTemplate = new AtomicBoolean(false);
    private WorkspaceProject newProject;

    @PostConstruct
    public void init() {
        if ("true".equalsIgnoreCase(System.getProperty("org.kie.demo"))) {
            Set projects = this.libraryService.getExampleProjects();
            projects.stream().filter(p -> "itorders".equals(p.getName())).findFirst().ifPresent(p -> {
                LOGGER.info("Importing IT Orders case management demo project...");
                this.newProject = this.libraryService.importProject(this.libraryService.getDefaultOrganizationalUnit(), p);
                LOGGER.info("Building It Orders case management demo project...");
                BuildResults results = this.buildService.buildAndDeploy(this.newProject.getMainModule());
                LOGGER.debug("It Orders project build errors: {}", (Object)results.getErrorMessages().size());
                if (results.getErrorMessages().isEmpty()) {
                    this.deployToServerTemplate.set(true);
                }
            });
        }
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        if (this.deployToServerTemplate.compareAndSet(true, false)) {
            GAV gav = this.newProject.getMainModule().getPom().getGav();
            String containerId = gav.getArtifactId() + "_" + gav.getVersion();
            ReleaseId releaseId = new ReleaseId(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
            ContainerSpec containerSpec = new ContainerSpec(containerId, gav.getArtifactId(), (ServerTemplateKey)serverTemplateUpdated.getServerTemplate(), releaseId, KieContainerStatus.STARTED, new HashMap());
            LOGGER.info("Creating Kie Server container with id: {} for Server Template: {}", (Object)containerId, (Object)serverTemplateUpdated.getServerTemplate().getId());
            this.specManagementService.saveContainerSpec(serverTemplateUpdated.getServerTemplate().getId(), containerSpec);
        }
    }
}

