/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.wi.casemgmt.service.CaseProjectService;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.kie.workbench.common.screens.projecteditor.client.handlers.NewProjectHandlerView;
import org.kie.workbench.common.screens.projecteditor.client.resources.ProjectEditorResources;
import org.kie.workbench.common.screens.projecteditor.client.wizard.NewProjectWizard;
import org.kie.workbench.common.screens.projecteditor.client.wizard.POMBuilder;
import org.kie.workbench.common.widgets.client.handlers.NewProjectHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.type.AnyResourceTypeDefinition;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
public class NewCaseProjectHandler
implements NewProjectHandler {
    private NewProjectHandlerView view;
    private ProjectContext context;
    private NewProjectWizard wizard;
    private Caller<RepositoryStructureService> repoStructureService;
    private ProjectController projectController;
    private AnyResourceTypeDefinition resourceType;
    private Caller<CaseProjectService> caseProjectService;
    private Event<NotificationEvent> notification;
    private boolean openEditorOnCreation = true;
    private org.uberfire.client.callbacks.Callback<Project> creationSuccessCallback;
    org.uberfire.client.callbacks.Callback<Project> configureCaseProjectCallback = new org.uberfire.client.callbacks.Callback<Project>(){

        public void callback(final Project project) {
            if (project != null) {
                ((CaseProjectService)NewCaseProjectHandler.this.caseProjectService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        NewCaseProjectHandler.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.ConfigureProjectSuccess(project.getProjectName()), NotificationEvent.NotificationType.SUCCESS));
                        if (NewCaseProjectHandler.this.creationSuccessCallback != null) {
                            NewCaseProjectHandler.this.creationSuccessCallback.callback((Object)project);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback(){

                    public boolean error(Message message, Throwable throwable) {
                        NewCaseProjectHandler.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.ConfigureProjectFailure(project.getProjectName()), NotificationEvent.NotificationType.ERROR));
                        return super.error(message, throwable);
                    }
                })).configureNewCaseProject(project);
            }
        }
    };

    @Inject
    public void setCaseProjectService(Caller<CaseProjectService> caseProjectService) {
        this.caseProjectService = caseProjectService;
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    public NewCaseProjectHandler() {
    }

    @Inject
    public NewCaseProjectHandler(NewProjectHandlerView view, ProjectContext context, NewProjectWizard wizard, Caller<RepositoryStructureService> repoStructureService, ProjectController projectController, AnyResourceTypeDefinition resourceType) {
        this.view = view;
        this.context = context;
        this.wizard = wizard;
        this.repoStructureService = repoStructureService;
        this.projectController = projectController;
        this.resourceType = resourceType;
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        return Collections.emptyList();
    }

    public String getDescription() {
        return Constants.INSTANCE.CaseProject();
    }

    public IsWidget getIcon() {
        return new Image(ProjectEditorResources.INSTANCE.newProjectIcon());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public boolean canCreate() {
        return this.projectController.canCreateProjects();
    }

    public void create(Package pkg, String projectName, NewResourcePresenter presenter) {
        throw new UnsupportedOperationException();
    }

    public void validate(String projectName, ValidatorWithReasonCallback callback) {
        throw new UnsupportedOperationException();
    }

    public void acceptContext(final Callback<Boolean, Void> response) {
        if (this.context.getActiveRepository() != null) {
            ((RepositoryStructureService)this.repoStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                public void callback(RepositoryStructureModel repoModel) {
                    if (repoModel != null && repoModel.isManaged().booleanValue()) {
                        boolean isMultiModule = repoModel.isMultiModule();
                        response.onSuccess((Object)isMultiModule);
                    } else {
                        response.onSuccess((Object)true);
                    }
                }
            })).load(this.context.getActiveRepository(), this.context.getActiveBranch());
        } else {
            response.onSuccess((Object)false);
        }
    }

    public Command getCommand(NewResourcePresenter newResourcePresenter) {
        return new Command(){

            public void execute() {
                if (NewCaseProjectHandler.this.context.getActiveRepository() != null) {
                    ((RepositoryStructureService)NewCaseProjectHandler.this.repoStructureService.call((RemoteCallback)new RemoteCallback<RepositoryStructureModel>(){

                        public void callback(RepositoryStructureModel repositoryStructureModel) {
                            POMBuilder builder = new POMBuilder();
                            if (repositoryStructureModel != null && repositoryStructureModel.isManaged().booleanValue()) {
                                builder.setProjectName("").setGroupId(repositoryStructureModel.getPOM().getGav().getGroupId()).setVersion(repositoryStructureModel.getPOM().getGav().getVersion());
                            } else {
                                builder.setProjectName("").setGroupId(NewCaseProjectHandler.this.context.getActiveOrganizationalUnit().getDefaultGroupId());
                            }
                            NewCaseProjectHandler.this.wizard.initialise(builder.build());
                            NewCaseProjectHandler.this.wizard.start(NewCaseProjectHandler.this.configureCaseProjectCallback, NewCaseProjectHandler.this.openEditorOnCreation);
                        }
                    })).load(NewCaseProjectHandler.this.context.getActiveRepository(), NewCaseProjectHandler.this.context.getActiveBranch());
                } else {
                    NewCaseProjectHandler.this.view.showNoRepositorySelectedPleaseSelectARepository();
                }
            }
        };
    }

    public ProjectContext getProjectContext() {
        return this.context;
    }

    public void setCreationSuccessCallback(org.uberfire.client.callbacks.Callback<Project> creationSuccessCallback) {
        this.creationSuccessCallback = creationSuccessCallback;
    }

    public void setOpenEditorOnCreation(boolean openEditorOnCreation) {
        this.openEditorOnCreation = openEditorOnCreation;
    }
}

