/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.casemgmt;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningCompletedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningFailedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningStartedEvent;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningService;
import org.jbpm.workbench.wi.client.casemgmt.CaseProvisioningAppLauncherHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.popups.launcher.events.AppLauncherAddEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class CaseProvisioningAppLauncherHandlerTest {
    @Spy
    Event<AppLauncherAddEvent> appLauncherAddEvent = new EventSourceMock();
    @Spy
    Event<NotificationEvent> notification = new EventSourceMock();
    @Mock
    CaseProvisioningService caseManagementService;
    @InjectMocks
    CaseProvisioningAppLauncherHandler appLauncherHandler;

    @Before
    public void init() {
        CallerMock service = new CallerMock((Object)this.caseManagementService);
        this.appLauncherHandler.setCaseProvisioningService((Caller)service);
        ((Event)Mockito.doNothing().when(this.notification)).fire(Matchers.any(NotificationEvent.class));
        ((Event)Mockito.doNothing().when(this.appLauncherAddEvent)).fire(Matchers.any(AppLauncherAddEvent.class));
    }

    @Test
    public void testVerifyCaseAppEmpty() {
        Mockito.when((Object)this.caseManagementService.getApplicationContext()).thenReturn((Object)"");
        this.appLauncherHandler.verifyCaseAppStatus();
        ((Event)Mockito.verify(this.appLauncherAddEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(AppLauncherAddEvent.class));
    }

    @Test
    public void testVerifyCaseAppNull() {
        Mockito.when((Object)this.caseManagementService.getApplicationContext()).thenReturn(null);
        this.appLauncherHandler.verifyCaseAppStatus();
        ((Event)Mockito.verify(this.appLauncherAddEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(AppLauncherAddEvent.class));
    }

    @Test
    public void testVerifyCaseApp() {
        Mockito.when((Object)this.caseManagementService.getApplicationContext()).thenReturn((Object)"/context");
        this.appLauncherHandler.verifyCaseAppStatus();
        ((Event)Mockito.verify(this.appLauncherAddEvent)).fire(Matchers.any(AppLauncherAddEvent.class));
    }

    @Test
    public void testOnCaseManagementProvisioningStartedEvent() {
        this.appLauncherHandler.onCaseManagementProvisioningStartedEvent(new CaseProvisioningStartedEvent());
        ((Event)Mockito.verify(this.appLauncherAddEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(AppLauncherAddEvent.class));
        this.assertNotification(NotificationEvent.NotificationType.DEFAULT);
    }

    @Test
    public void testOnCaseManagementProvisioningCompletedEvent() {
        this.appLauncherHandler.onCaseManagementProvisioningCompletedEvent(new CaseProvisioningCompletedEvent("/context"));
        ((Event)Mockito.verify(this.appLauncherAddEvent)).fire(Matchers.any(AppLauncherAddEvent.class));
        this.assertNotification(NotificationEvent.NotificationType.SUCCESS);
    }

    @Test
    public void testOnCaseManagementProvisioningFailedEvent() {
        this.appLauncherHandler.onCaseManagementProvisioningFailedEvent(new CaseProvisioningFailedEvent());
        ((Event)Mockito.verify(this.appLauncherAddEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(AppLauncherAddEvent.class));
        this.assertNotification(NotificationEvent.NotificationType.ERROR);
    }

    protected void assertNotification(NotificationEvent.NotificationType notificationType) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((Event)Mockito.verify(this.notification)).fire(captor.capture());
        Assert.assertEquals((Object)notificationType, (Object)((NotificationEvent)captor.getValue()).getType());
    }
}

