/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwt.user.client.Command;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.m2repo.utils.FileNameUtilities;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormView;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ServiceTaskUploadFormPresenter
implements ServiceTaskUploadFormView.Presenter {
    public static final String UPLOAD_FAILED = "ERROR";
    private ServiceTaskUploadFormView view;
    private Caller<ServiceTaskService> serviceTaskService;
    private Command onUploadCompleted;
    private Command onClose;
    private Event<NotificationEvent> notificationEvent;

    @Inject
    public ServiceTaskUploadFormPresenter(ServiceTaskUploadFormView view, Caller<ServiceTaskService> serviceTaskService, Event<NotificationEvent> notificationEvent, SyncBeanManager iocManager) {
        this.view = view;
        this.serviceTaskService = serviceTaskService;
        this.notificationEvent = notificationEvent;
        this.onClose = () -> iocManager.destroyBean((Object)this);
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Override
    public void handleSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
        this.view.hideUploadingBusy();
        if ("MISSING_POM".equalsIgnoreCase(event.getResults())) {
            this.view.showInvalidJarNoPomWarning();
            this.view.hide();
        } else if ("UNABLE_TO_PARSE_POM".equalsIgnoreCase(event.getResults())) {
            this.view.showInvalidPomWarning();
            this.view.hide();
        } else if (UPLOAD_FAILED.equalsIgnoreCase(event.getResults())) {
            this.view.showUploadFailedError();
            this.view.hide();
        } else {
            ((ServiceTaskService)this.serviceTaskService.call(serviceTasks -> {
                String addTaskSuccessMsg = this.view.getSuccessInstallMessage();
                String addedServiceTasks = serviceTasks.stream().collect(Collectors.joining(","));
                this.notificationEvent.fire((Object)new NotificationEvent(addTaskSuccessMsg + addedServiceTasks, NotificationEvent.NotificationType.SUCCESS));
                this.onUploadCompleted.execute();
                this.view.hide();
            })).addServiceTasks(event.getResults());
        }
    }

    @Override
    public boolean isFileNameValid() {
        String fileName = this.view.getFileName();
        if (fileName == null || "".equals(fileName)) {
            this.view.showSelectFileUploadWarning();
            return false;
        }
        if (!FileNameUtilities.isValid((String)fileName)) {
            this.view.showUnsupportedFileTypeWarning();
            return false;
        }
        this.view.showUploadingBusy();
        return true;
    }

    public void showView(Command onUploadCompleted) {
        this.onUploadCompleted = onUploadCompleted;
        this.view.show();
    }

    @Override
    public Command onCloseCommand() {
        return this.onClose;
    }
}

