/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.general;

import elemental2.promise.Promise;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.AuditMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.PersistenceMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.RuntimeStrategy;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.general.DeploymentsGeneralSettingsView;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.library.client.settings.util.select.KieEnumSelectElement;
import org.uberfire.client.promise.Promises;

@Dependent
public class DeploymentsGeneralSettingsPresenter
extends Section<DeploymentDescriptorModel> {
    private final DeploymentsGeneralSettingsView view;
    private final KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect;
    private final KieEnumSelectElement<PersistenceMode> persistenceModesSelect;
    private final KieEnumSelectElement<AuditMode> auditModesSelect;
    protected DeploymentDescriptorModel model;

    @Inject
    public DeploymentsGeneralSettingsPresenter(Event<SettingsSectionChange<DeploymentDescriptorModel>> settingsSectionChangeEvent, MenuItem<DeploymentDescriptorModel> menuItem, Promises promises, DeploymentsGeneralSettingsView view, KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect, KieEnumSelectElement<PersistenceMode> persistenceModesSelect, KieEnumSelectElement<AuditMode> auditModesSelect) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.runtimeStrategiesSelect = runtimeStrategiesSelect;
        this.persistenceModesSelect = persistenceModesSelect;
        this.auditModesSelect = auditModesSelect;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Promise<Void> setup(DeploymentDescriptorModel model) {
        this.model = model;
        this.setupRuntimeStrategiesSelect(model);
        this.view.setPersistenceUnitName(model.getPersistenceUnitName());
        this.setupPersistenceModesSelect(model);
        this.view.setAuditPersistenceUnitName(model.getAuditPersistenceUnitName());
        this.setupAuditModeSelect(model);
        return this.promises.resolve();
    }

    void setupAuditModeSelect(DeploymentDescriptorModel model) {
        this.auditModesSelect.setup(this.view.getAuditModesContainer(), (Enum[])AuditMode.values(), (Enum)AuditMode.valueOf(model.getAuditMode()), auditMode -> {
            model.setAuditMode(auditMode.name());
            this.fireChangeEvent();
        });
    }

    void setupPersistenceModesSelect(DeploymentDescriptorModel model) {
        this.persistenceModesSelect.setup(this.view.getPersistenceModesContainer(), (Enum[])PersistenceMode.values(), (Enum)PersistenceMode.valueOf(model.getPersistenceMode()), persistenceMode -> {
            model.setPersistenceMode(persistenceMode.name());
            this.fireChangeEvent();
        });
    }

    void setupRuntimeStrategiesSelect(DeploymentDescriptorModel model) {
        this.runtimeStrategiesSelect.setup(this.view.getRuntimeStrategiesContainer(), (Enum[])RuntimeStrategy.values(), (Enum)RuntimeStrategy.valueOf(model.getRuntimeStrategy()), runtimeStrategy -> {
            model.setRuntimeStrategy(runtimeStrategy.name());
            this.fireChangeEvent();
        });
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.model.setPersistenceUnitName(persistenceUnitName);
        this.fireChangeEvent();
    }

    public void setAuditPersistenceUnitName(String auditPersistenceUnitName) {
        this.model.setAuditPersistenceUnitName(auditPersistenceUnitName);
        this.fireChangeEvent();
    }

    public SectionView<?> getView() {
        return this.view;
    }

    public int currentHashCode() {
        return this.model.getAuditMode().hashCode() + this.model.getPersistenceUnitName().hashCode() + this.model.getAuditPersistenceUnitName().hashCode() + this.model.getPersistenceMode().hashCode() + this.model.getRuntimeStrategy().hashCode();
    }
}

