/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwt.user.client.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Branch;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.workitem.project.ServiceTaskInstallFormPresenter;
import org.jbpm.workbench.wi.client.workitem.project.ServiceTaskInstallFormView;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ServiceTaskInstallFormPresenterTest {
    private ServiceTaskInstallFormPresenter presenter;
    @Mock
    private ServiceTaskInstallFormView view;
    @Mock
    private ServiceTaskService serviceTaskService;
    @Mock
    private WorkspaceProjectContext workspaceProjectContext;
    @Mock
    private WorkspaceProject workspaceProject;
    @Mock
    private Branch branch;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private Command cmd;
    private String serviceTaskId = "1111";
    private String target = "space/project";
    private List<String> parameters = new ArrayList<String>();

    @Before
    public void before() {
        this.presenter = (ServiceTaskInstallFormPresenter)Mockito.spy((Object)new ServiceTaskInstallFormPresenter(this.view, (Caller)new CallerMock((Object)this.serviceTaskService), this.iocManager));
        this.presenter.init();
        Mockito.when((Object)this.workspaceProjectContext.getActiveWorkspaceProject()).thenReturn(Optional.of(this.workspaceProject));
        Mockito.when((Object)this.workspaceProject.getBranch()).thenReturn((Object)this.branch);
    }

    @Test
    public void testInstallServiceTask() {
        Mockito.when((Object)this.branch.getName()).thenReturn((Object)"master");
        this.presenter.showView(this.cmd, this.serviceTaskId, this.target, this.parameters, null);
        this.presenter.setWorkspaceProjectContext(this.workspaceProjectContext);
        this.presenter.installWithParameters(this.serviceTaskId, this.target, this.parameters);
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.times((int)1))).installServiceTask((String)Matchers.eq((Object)this.serviceTaskId), (String)Matchers.eq((Object)this.target), (List)Matchers.eq(this.parameters), (String)Matchers.eq((Object)"master"));
        ((Command)Mockito.verify((Object)this.cmd, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void testInstallServiceTaskCustomBranch() {
        Mockito.when((Object)this.branch.getName()).thenReturn((Object)"customBranch");
        this.presenter.showView(this.cmd, this.serviceTaskId, this.target, this.parameters, null);
        this.presenter.setWorkspaceProjectContext(this.workspaceProjectContext);
        this.presenter.installWithParameters(this.serviceTaskId, this.target, this.parameters);
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.times((int)1))).installServiceTask((String)Matchers.eq((Object)this.serviceTaskId), (String)Matchers.eq((Object)this.target), (List)Matchers.eq(this.parameters), (String)Matchers.eq((Object)"customBranch"));
        ((Command)Mockito.verify((Object)this.cmd, (VerificationMode)Mockito.times((int)1))).execute();
    }
}

