/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem.project;

import com.google.gwt.user.client.Command;
import elemental2.dom.Element;
import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.workitem.project.ProjectServiceTaskItemPresenter;
import org.jbpm.workbench.wi.client.workitem.project.ServiceTaskInstallFormPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.uberfire.client.promise.Promises;

public class ProjectServiceTasksPresenter
extends Section<ProjectScreenModel> {
    private final View view;
    private final ServiceTasksListPresenter serviceTasksItemPresenters;
    private final Caller<ServiceTaskService> serviceTasksService;
    private ProjectScreenModel model;
    private SyncBeanManager iocManager;
    @Inject
    WorkspaceProjectContext workspaceProjectContext;

    @Inject
    public ProjectServiceTasksPresenter(View view, Promises promises, MenuItem<ProjectScreenModel> menuItem, Event<SettingsSectionChange<ProjectScreenModel>> settingsSectionChangeEvent, Caller<ServiceTaskService> serviceTasksService, ServiceTasksListPresenter serviceTasksItemPresenters, SyncBeanManager iocManager) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.serviceTasksItemPresenters = serviceTasksItemPresenters;
        this.serviceTasksService = serviceTasksService;
        this.iocManager = iocManager;
    }

    public Promise<Void> setup(ProjectScreenModel model) {
        this.model = model;
        this.view.init((Object)this);
        return this.loadServiceTasks(this.getBranchName()).then(tasks -> this.promises.create((resolve, reject) -> {
            this.serviceTasksItemPresenters.setup(this.view.getServiceTasksTable(), (List)tasks, (serviceTask, presenter) -> presenter.setup((ServiceTaskSummary)serviceTask, this));
            resolve.onInvoke((IThenable)this.promises.resolve());
        }));
    }

    Promise<List<ServiceTaskSummary>> loadServiceTasks(String branchName) {
        return this.promises.promisify(this.serviceTasksService, s -> s.getEnabledServiceTasks(branchName));
    }

    public int currentHashCode() {
        return 0;
    }

    public SectionView<?> getView() {
        return this.view;
    }

    public void installServiceTask(String serviceTaskId, List<String> parameters, String referenceLink, Command onDone) {
        if (parameters.isEmpty()) {
            ((ServiceTaskService)this.serviceTasksService.call(Void2 -> {
                onDone.execute();
                this.fireChangeEvent();
            })).installServiceTask(serviceTaskId, this.getInstallTarget(), null, this.getBranchName());
        } else {
            ServiceTaskInstallFormPresenter installFormPresenter = (ServiceTaskInstallFormPresenter)this.iocManager.lookupBean(ServiceTaskInstallFormPresenter.class, new Annotation[0]).newInstance();
            installFormPresenter.showView(onDone, serviceTaskId, this.getInstallTarget(), parameters, referenceLink);
        }
    }

    public void uninstallServiceTask(String serviceTaskId, Command onDone) {
        ((ServiceTaskService)this.serviceTasksService.call(Void2 -> {
            onDone.execute();
            this.fireChangeEvent();
        })).uninstallServiceTask(serviceTaskId, this.getInstallTarget(), this.getBranchName());
    }

    public String getInstallTarget() {
        String uri = this.model.getPathToPOM().toString().replaceAll("\\/pom.xml", "");
        if (uri.contains("@")) {
            return uri.substring(uri.indexOf("@") + 1);
        }
        return uri.substring(uri.indexOf("://") + 3);
    }

    public void newBranchEvent(@Observes NewBranchEvent newBranchEvent) {
        ((ServiceTaskService)this.serviceTasksService.call(Void2 -> {})).updateInstalledServiceTasks(newBranchEvent.getNewBranchName(), newBranchEvent.getFromBranchName());
    }

    public String getBranchName() {
        String branchName = null;
        if (this.workspaceProjectContext != null) {
            branchName = ((WorkspaceProject)this.workspaceProjectContext.getActiveWorkspaceProject().get()).getBranch().getName();
        }
        return branchName;
    }

    @Dependent
    public static class ServiceTasksListPresenter
    extends ListPresenter<ServiceTaskSummary, ProjectServiceTaskItemPresenter> {
        @Inject
        public ServiceTasksListPresenter(ManagedInstance<ProjectServiceTaskItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends SectionView<ProjectServiceTasksPresenter> {
        public Element getServiceTasksTable();
    }
}

