/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentDescriptorEditorPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentDescriptorView;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentDescriptorViewImpl;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DeploymentDescriptorEditorPresenterTest {
    @Mock
    protected BasicFileMenuBuilder menuBuilder;
    @Mock
    protected VersionRecordManager versionRecordManager;
    @Spy
    @InjectMocks
    protected FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    protected ProjectController projectController;
    @Mock
    protected ProjectContext workbenchContext;
    @Mock
    DeploymentDescriptorViewImpl view;
    DeploymentDescriptorEditorPresenter presenter;
    private CallerMock<DDEditorService> callerMockDDEditorService;
    @Mock
    private DDEditorService ddEditorServiceMock;

    @Before
    public void setUp() throws Exception {
        this.callerMockDDEditorService = new CallerMock((Object)this.ddEditorServiceMock);
        this.presenter = new DeploymentDescriptorEditorPresenter((DeploymentDescriptorView)this.view, (Caller)this.callerMockDDEditorService, (TranslationService)Mockito.mock(TranslationService.class)){
            {
                this.kieView = (KieEditorWrapperView)Mockito.mock(KieEditorWrapperView.class);
                this.overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
                this.concurrentUpdateSessionInfo = null;
                this.fileMenuBuilder = DeploymentDescriptorEditorPresenterTest.this.fileMenuBuilder;
                this.projectController = DeploymentDescriptorEditorPresenterTest.this.projectController;
                this.workbenchContext = DeploymentDescriptorEditorPresenterTest.this.workbenchContext;
                this.versionRecordManager = DeploymentDescriptorEditorPresenterTest.this.versionRecordManager;
            }

            protected void addSourcePage() {
            }
        };
    }

    @Test
    public void testDeploymentDescriptorEditorSetup() throws Exception {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((DeploymentDescriptorViewImpl)Mockito.verify((Object)this.view)).setSourceTabReadOnly(true);
        ((DeploymentDescriptorViewImpl)Mockito.verify((Object)this.view)).setup();
        ((DeploymentDescriptorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)RuntimeStrategy.values().length))).addRuntimeStrategy(Mockito.anyString(), Mockito.anyString());
        ((DeploymentDescriptorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addPersistenceMode(Mockito.anyString(), Mockito.anyString());
        ((DeploymentDescriptorViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addAuditMode(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testMakeMenuBar() {
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any(MenuItem.class));
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
    }
}

