/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormPresenter;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormView;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ServiceTaskUploadFormPresenterTest {
    private static final String ADD_TASK_SUCCESS = "Service tasks successfully added -";
    private static final String SKIP_TASK_SUCCESS = "The following service tasks have been skipped as the repository already contains services with the same name as: SKIP.";
    private ServiceTaskUploadFormPresenter presenter;
    @Mock
    private ServiceTaskUploadFormView view;
    @Mock
    private ServiceTaskService serviceTaskService;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    private SyncBeanManager iocManager;
    private List<String> createdList = Collections.singletonList("Created");
    private List<String> skippedList = Collections.singletonList("Skipped");

    @Before
    public void before() {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        resultMap.put("Created", this.createdList);
        resultMap.put("Skipped", this.skippedList);
        Mockito.when((Object)this.serviceTaskService.addServiceTasks((String)Matchers.any())).thenReturn(resultMap);
        this.presenter = (ServiceTaskUploadFormPresenter)Mockito.spy((Object)new ServiceTaskUploadFormPresenter(this.view, (Caller)new CallerMock((Object)this.serviceTaskService), this.notificationEvent, this.iocManager));
        this.presenter.init();
        Mockito.when((Object)this.view.getSuccessInstallMessage()).thenReturn((Object)ADD_TASK_SUCCESS);
        Mockito.when((Object)this.view.getSkippedMessage((String)Matchers.any())).thenReturn((Object)SKIP_TASK_SUCCESS);
    }

    @Test
    public void testOnCloseCommand() {
        Assert.assertNotNull((Object)this.presenter.onCloseCommand());
    }

    @Test
    public void testUploadMissingPom() {
        AbstractForm.SubmitCompleteEvent event = (AbstractForm.SubmitCompleteEvent)Mockito.mock(AbstractForm.SubmitCompleteEvent.class);
        Mockito.when((Object)event.getResults()).thenReturn((Object)"MISSING_POM");
        this.presenter.handleSubmitComplete(event);
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showInvalidJarNoPomWarning();
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.never())).addServiceTasks((String)Matchers.any());
    }

    @Test
    public void testUploadInvalidPom() {
        AbstractForm.SubmitCompleteEvent event = (AbstractForm.SubmitCompleteEvent)Mockito.mock(AbstractForm.SubmitCompleteEvent.class);
        Mockito.when((Object)event.getResults()).thenReturn((Object)"UNABLE_TO_PARSE_POM");
        this.presenter.handleSubmitComplete(event);
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showInvalidPomWarning();
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.never())).addServiceTasks((String)Matchers.any());
    }

    @Test
    public void testUploadFailed() {
        AbstractForm.SubmitCompleteEvent event = (AbstractForm.SubmitCompleteEvent)Mockito.mock(AbstractForm.SubmitCompleteEvent.class);
        Mockito.when((Object)event.getResults()).thenReturn((Object)"ERROR");
        this.presenter.handleSubmitComplete(event);
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showUploadFailedError();
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.never())).addServiceTasks((String)Matchers.any());
    }

    @Test
    public void testUploadSuccessful() {
        String gav = "org.test:artifact:1.0";
        AbstractForm.SubmitCompleteEvent event = (AbstractForm.SubmitCompleteEvent)Mockito.mock(AbstractForm.SubmitCompleteEvent.class);
        Mockito.when((Object)event.getResults()).thenReturn((Object)gav);
        this.presenter.showView(() -> {});
        this.presenter.handleSubmitComplete(event);
        ((ServiceTaskUploadFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hide();
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.times((int)1))).addServiceTasks((String)Matchers.eq((Object)gav));
        ((EventSourceMock)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(ADD_TASK_SUCCESS + this.createdList.stream().collect(Collectors.joining(",")) + "/n" + SKIP_TASK_SUCCESS, NotificationEvent.NotificationType.SUCCESS));
    }
}

