/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import java.util.Arrays;
import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.DeploymentsSections;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.general.DeploymentsGeneralSettingsPresenter;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionManager;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentsSectionPresenterTest {
    private DeploymentsSectionPresenter presenter;
    @Mock
    private DeploymentsSectionPresenter.View view;
    @Mock
    private MenuItem<ProjectScreenModel> menuItem;
    @Mock
    private WorkspaceProjectContext projectContext;
    @Mock
    private DDEditorService ddEditorService;
    @Mock
    private ManagedInstance<ObservablePath> observablePaths;
    @Mock
    private EventSourceMock<SettingsSectionChange<ProjectScreenModel>> settingsSectionChangeEvent;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    private DeploymentsSections deploymentsSections;
    @Mock
    private DeploymentsGeneralSettingsPresenter section1;
    @Mock
    private DeploymentsGeneralSettingsPresenter section2;
    @Mock
    private SectionManager<DeploymentDescriptorModel> sectionManager;
    private final Promises promises = new SyncPromises();

    @Before
    public void before() {
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ObservablePath)Mockito.doReturn((Object)observablePath).when((Object)observablePath)).wrap((Path)Matchers.any());
        ((ManagedInstance)Mockito.doReturn((Object)observablePath).when(this.observablePaths)).get();
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(Optional.of(project));
        Mockito.when((Object)project.getRootPath()).thenReturn(Mockito.mock(Path.class));
        Mockito.when((Object)project.getRootPath().toURI()).thenReturn((Object)"root");
        Mockito.when((Object)this.deploymentsSections.getList()).thenReturn(Arrays.asList(this.section1, this.section2));
        Mockito.when((Object)this.section1.setup((DeploymentDescriptorModel)Matchers.any())).thenReturn((Object)this.promises.resolve());
        Mockito.when((Object)this.section2.setup((DeploymentDescriptorModel)Matchers.any())).thenReturn((Object)this.promises.resolve());
        this.presenter = (DeploymentsSectionPresenter)Mockito.spy((Object)new DeploymentsSectionPresenter(this.view, this.promises, this.menuItem, this.projectContext, (Caller)new CallerMock((Object)this.ddEditorService), this.observablePaths, this.settingsSectionChangeEvent, this.notificationEvent, this.sectionManager, this.deploymentsSections));
        this.presenter.init();
    }

    @Test
    public void testSetup() {
        DeploymentDescriptorModel model = (DeploymentDescriptorModel)Mockito.mock(DeploymentDescriptorModel.class);
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.presenter)).createIfNotExists();
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve((Object)model)).when((Object)this.presenter)).loadDeploymentDescriptor();
        Mockito.when((Object)this.sectionManager.goToCurrentSection()).thenReturn((Object)this.promises.resolve());
        this.presenter.setup((ProjectScreenModel)Mockito.mock(ProjectScreenModel.class)).catch_(i -> {
            Assert.fail((String)("Promise should've been resolved!\n" + ((Throwable)i).getMessage()));
            return this.promises.resolve();
        });
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter)).createIfNotExists();
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter)).loadDeploymentDescriptor();
        ((DeploymentsSectionPresenter.View)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.presenter));
        ((DeploymentsGeneralSettingsPresenter)Mockito.verify((Object)this.section1)).setup((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsGeneralSettingsPresenter)Mockito.verify((Object)this.section2)).setup((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((SectionManager)Mockito.verify(this.sectionManager)).goToCurrentSection();
        ((SectionManager)Mockito.verify(this.sectionManager)).resetAllDirtyIndicators();
    }

    @Test
    public void testCreateIfNotExists() {
        ((DDEditorService)Mockito.doNothing().when((Object)this.ddEditorService)).createIfNotExists((Path)Matchers.any());
        this.presenter.createIfNotExists().catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).createIfNotExists((Path)Matchers.any());
    }

    @Test
    public void testLoadDeploymentDescriptor() {
        ((DDEditorService)Mockito.doReturn((Object)Mockito.mock(DeploymentDescriptorModel.class)).when((Object)this.ddEditorService)).load((Path)Matchers.any());
        this.presenter.loadDeploymentDescriptor().catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).load((Path)Matchers.any());
    }

    @Test
    public void testSave() {
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.presenter)).save((String)Matchers.eq((Object)"Test comment"));
        this.presenter.save("Test comment", null).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter)).save((String)Matchers.eq((Object)"Test comment"));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setup();
        ((EventSourceMock)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testSaveWithConcurrentUpdate() {
        this.presenter.concurrentDeploymentsXmlUpdateInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.presenter)).setup();
        this.presenter.save("Test comment", null).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).save((String)Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.presenter)).setup();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testSaveModel() {
        ((DDEditorService)Mockito.doReturn((Object)Mockito.mock(Path.class)).when((Object)this.ddEditorService)).save((Path)Matchers.any(), Matchers.any(), (Metadata)Matchers.any(), (String)Matchers.any());
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        model.setOverview(new Overview());
        this.presenter.model = model;
        this.presenter.save("Test comment").catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).save((Path)Matchers.any(), Matchers.any(), (Metadata)Matchers.any(), (String)Matchers.eq((Object)"Test comment"));
    }
}

