/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.general;

import com.google.gwt.event.dom.client.ChangeEvent;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLInputElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.AuditMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.PersistenceMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.RuntimeStrategy;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.general.DeploymentsGeneralSettingsPresenter;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.library.client.settings.util.select.KieEnumSelectElement;

@Templated
public class DeploymentsGeneralSettingsView
implements SectionView<DeploymentsGeneralSettingsPresenter> {
    @Inject
    @Named(value="h3")
    @DataField(value="title")
    private HTMLHeadingElement title;
    @Inject
    @DataField(value="runtime-strategies")
    private KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect;
    @Inject
    @DataField(value="persistence-unit-name")
    private HTMLInputElement persistenceUnitName;
    @Inject
    @DataField(value="persistence-modes")
    private KieEnumSelectElement<PersistenceMode> persistenceModesSelect;
    @Inject
    @DataField(value="audit-persistence-unit-name")
    private HTMLInputElement auditPersistenceUnitName;
    @Inject
    @DataField(value="audit-modes")
    private KieEnumSelectElement<AuditMode> auditModesSelect;
    private DeploymentsGeneralSettingsPresenter presenter;

    public void init(DeploymentsGeneralSettingsPresenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"persistence-unit-name"})
    public void onPersistenceUnitNameChanged(ChangeEvent ignore) {
        this.presenter.setPersistenceUnitName(this.persistenceUnitName.value);
    }

    @EventHandler(value={"audit-persistence-unit-name"})
    public void onAuditPersistenceUnitNameChanged(ChangeEvent ignore) {
        this.presenter.setAuditPersistenceUnitName(this.auditPersistenceUnitName.value);
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName.value = persistenceUnitName;
    }

    public void setAuditPersistenceUnitName(String auditPersistenceUnitName) {
        this.auditPersistenceUnitName.value = auditPersistenceUnitName;
    }

    public void setupAuditModeSelect(DeploymentDescriptorModel model) {
        this.auditModesSelect.setup((Enum[])AuditMode.values(), (Enum)AuditMode.valueOf(model.getAuditMode()), auditMode -> {
            model.setAuditMode(auditMode.name());
            this.presenter.fireChangeEvent();
        });
    }

    public void setupPersistenceModesSelect(DeploymentDescriptorModel model) {
        this.persistenceModesSelect.setup((Enum[])PersistenceMode.values(), (Enum)PersistenceMode.valueOf(model.getPersistenceMode()), persistenceMode -> {
            model.setPersistenceMode(persistenceMode.name());
            this.presenter.fireChangeEvent();
        });
    }

    public void setupRuntimeStrategiesSelect(DeploymentDescriptorModel model) {
        this.runtimeStrategiesSelect.setup((Enum[])RuntimeStrategy.values(), (Enum)RuntimeStrategy.valueOf(model.getRuntimeStrategy()), runtimeStrategy -> {
            model.setRuntimeStrategy(runtimeStrategy.name());
            this.presenter.fireChangeEvent();
        });
    }

    public String getTitle() {
        return this.title.textContent;
    }
}

