/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import elemental2.dom.Element;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.AuditMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.PersistenceMode;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.RuntimeStrategy;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.KieEnumSelectElement;
import org.kie.workbench.common.screens.library.client.settings.util.modal.doublevalue.AddDoubleValueModal;
import org.kie.workbench.common.screens.library.client.settings.util.modal.single.AddSingleValueModal;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.mocks.CallerMock;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentsSectionPresenterTest {
    private DeploymentsSectionPresenter deploymentsSectionPresenter;
    @Mock
    private DeploymentsSectionPresenter.View view;
    @Mock
    private SettingsPresenter.MenuItem menuItem;
    @Mock
    private AddSingleValueModal addMarshallingStrategyModal;
    @Mock
    private AddSingleValueModal addEventListenerModal;
    @Mock
    private AddDoubleValueModal addGlobalModal;
    @Mock
    private AddSingleValueModal addRequiredRoleModal;
    @Mock
    private KieEnumSelectElement<RuntimeStrategy> runtimeStrategiesSelect;
    @Mock
    private KieEnumSelectElement<PersistenceMode> persistenceModesSelect;
    @Mock
    private KieEnumSelectElement<AuditMode> auditModesSelect;
    @Mock
    private WorkspaceProjectContext projectContext;
    @Mock
    private DDEditorService ddEditorService;
    @Mock
    private ManagedInstance<ObservablePath> observablePaths;
    @Mock
    private Event<SettingsSectionChange> settingsSectionChangeEvent;
    @Mock
    private DeploymentsSectionPresenter.MarshallingStrategiesListPresenter marshallingStrategyPresenters;
    @Mock
    private DeploymentsSectionPresenter.EventListenersListPresenter eventListenerPresenters;
    @Mock
    private DeploymentsSectionPresenter.GlobalsListPresenter globalPresenters;
    @Mock
    private DeploymentsSectionPresenter.RequiredRolesListPresenter requiredRolePresenters;
    @Mock
    private Event<NotificationEvent> notificationEvent;
    private final Promises promises = new SyncPromises();

    @Before
    public void before() {
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ObservablePath)Mockito.doReturn((Object)observablePath).when((Object)observablePath)).wrap((Path)Matchers.any());
        ((ManagedInstance)Mockito.doReturn((Object)observablePath).when(this.observablePaths)).get();
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(Optional.of(project));
        Mockito.when((Object)project.getRootPath()).thenReturn(Mockito.mock(Path.class));
        Mockito.when((Object)project.getRootPath().toURI()).thenReturn((Object)"root");
        this.deploymentsSectionPresenter = (DeploymentsSectionPresenter)Mockito.spy((Object)new DeploymentsSectionPresenter(this.view, this.promises, this.menuItem, this.addMarshallingStrategyModal, this.addEventListenerModal, this.addGlobalModal, this.addRequiredRoleModal, this.runtimeStrategiesSelect, this.persistenceModesSelect, this.auditModesSelect, this.projectContext, (Caller)new CallerMock((Object)this.ddEditorService), this.observablePaths, this.settingsSectionChangeEvent, this.marshallingStrategyPresenters, this.eventListenerPresenters, this.globalPresenters, this.requiredRolePresenters, this.notificationEvent));
    }

    @Test
    public void testSetup() {
        DeploymentDescriptorModel model = (DeploymentDescriptorModel)Mockito.mock(DeploymentDescriptorModel.class);
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.deploymentsSectionPresenter)).createIfNotExists();
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve((Object)model)).when((Object)this.deploymentsSectionPresenter)).loadDeploymentDescriptor();
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupAuditModeSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupPersistenceModesSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupRuntimeStrategiesSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupMarshallingStrategiesTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupEventListenersTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupGlobalsTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.doNothing().when((Object)this.deploymentsSectionPresenter)).setupRequiredRolesTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        this.deploymentsSectionPresenter.setup((ProjectScreenModel)Mockito.mock(ProjectScreenModel.class));
        ((DeploymentsSectionPresenter.View)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.deploymentsSectionPresenter));
        ((DeploymentsSectionPresenter.View)Mockito.verify((Object)this.view)).setAuditPersistenceUnitName((String)Matchers.any());
        ((DeploymentsSectionPresenter.View)Mockito.verify((Object)this.view)).setPersistenceUnitName((String)Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupRuntimeStrategiesSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupPersistenceModesSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupAuditModeSelect((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupMarshallingStrategiesTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupEventListenersTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupGlobalsTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setupRequiredRolesTable((DeploymentDescriptorModel)Matchers.eq((Object)model));
    }

    @Test
    public void testSetupRuntimeStrategiesSelect() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        model.setRuntimeStrategy("SINGLETON");
        this.deploymentsSectionPresenter.setupRuntimeStrategiesSelect(model);
        ((KieEnumSelectElement)Mockito.verify(this.runtimeStrategiesSelect)).setup((Element)Matchers.any(), (Enum[])Matchers.any(), (Enum)Matchers.any(), (Consumer)Matchers.any());
    }

    @Test
    public void testSetupPersistenceModesSelect() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        model.setPersistenceMode("JPA");
        this.deploymentsSectionPresenter.setupPersistenceModesSelect(model);
        ((KieEnumSelectElement)Mockito.verify(this.persistenceModesSelect)).setup((Element)Matchers.any(), (Enum[])Matchers.any(), (Enum)Matchers.any(), (Consumer)Matchers.any());
    }

    @Test
    public void testSetupAuditModeSelect() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        model.setAuditMode("JPA");
        this.deploymentsSectionPresenter.setupAuditModeSelect(model);
        ((KieEnumSelectElement)Mockito.verify(this.auditModesSelect)).setup((Element)Matchers.any(), (Enum[])Matchers.any(), (Enum)Matchers.any(), (Consumer)Matchers.any());
    }

    @Test
    public void testSetupMarshallingStrategiesTable() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setupMarshallingStrategiesTable(model);
        Assert.assertNotNull((Object)model.getMarshallingStrategies());
        ((AddSingleValueModal)Mockito.verify((Object)this.addMarshallingStrategyModal)).setup((String)Matchers.any(), (String)Matchers.any());
        ((DeploymentsSectionPresenter.MarshallingStrategiesListPresenter)Mockito.verify((Object)this.marshallingStrategyPresenters)).setup((Element)Matchers.any(), (List)Matchers.any(), (BiConsumer)Matchers.any());
    }

    @Test
    public void testSetupEventListenersTable() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setupEventListenersTable(model);
        Assert.assertNotNull((Object)model.getEventListeners());
        ((AddSingleValueModal)Mockito.verify((Object)this.addEventListenerModal)).setup((String)Matchers.any(), (String)Matchers.any());
        ((DeploymentsSectionPresenter.EventListenersListPresenter)Mockito.verify((Object)this.eventListenerPresenters)).setup((Element)Matchers.any(), (List)Matchers.any(), (BiConsumer)Matchers.any());
    }

    @Test
    public void testSetupGlobalsTable() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setupGlobalsTable(model);
        Assert.assertNotNull((Object)model.getGlobals());
        ((AddDoubleValueModal)Mockito.verify((Object)this.addGlobalModal)).setup((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any());
        ((DeploymentsSectionPresenter.GlobalsListPresenter)Mockito.verify((Object)this.globalPresenters)).setup((Element)Matchers.any(), (List)Matchers.any(), (BiConsumer)Matchers.any());
    }

    @Test
    public void testSetupRequiredRolesTable() {
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setupRequiredRolesTable(model);
        Assert.assertNotNull((Object)model.getRequiredRoles());
        ((AddSingleValueModal)Mockito.verify((Object)this.addRequiredRoleModal)).setup((String)Matchers.any(), (String)Matchers.any());
        ((DeploymentsSectionPresenter.RequiredRolesListPresenter)Mockito.verify((Object)this.requiredRolePresenters)).setup((Element)Matchers.any(), (List)Matchers.any(), (BiConsumer)Matchers.any());
    }

    @Test
    public void testCreateIfNotExists() {
        ((DDEditorService)Mockito.doNothing().when((Object)this.ddEditorService)).createIfNotExists((Path)Matchers.any());
        this.deploymentsSectionPresenter.createIfNotExists().catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).createIfNotExists((Path)Matchers.any());
    }

    @Test
    public void testLoadDeploymentDescriptor() {
        ((DDEditorService)Mockito.doReturn((Object)Mockito.mock(Path.class)).when((Object)this.ddEditorService)).load((Path)Matchers.any());
        this.deploymentsSectionPresenter.loadDeploymentDescriptor().catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).load((Path)Matchers.any());
    }

    @Test
    public void testOpenNewMarshallingStrategyModal() {
        this.deploymentsSectionPresenter.openNewMarshallingStrategyModal();
        ((AddSingleValueModal)Mockito.verify((Object)this.addMarshallingStrategyModal)).show((Consumer)Matchers.any());
    }

    @Test
    public void testOpenNewEventListenerModal() {
        this.deploymentsSectionPresenter.openNewEventListenerModal();
        ((AddSingleValueModal)Mockito.verify((Object)this.addEventListenerModal)).show((Consumer)Matchers.any());
    }

    @Test
    public void testOpenNewGlobalModal() {
        this.deploymentsSectionPresenter.openNewGlobalModal();
        ((AddDoubleValueModal)Mockito.verify((Object)this.addGlobalModal)).show((BiConsumer)Matchers.any());
    }

    @Test
    public void testOpenNewRequiredRoleModal() {
        this.deploymentsSectionPresenter.openNewRequiredRoleModal();
        ((AddSingleValueModal)Mockito.verify((Object)this.addRequiredRoleModal)).show((Consumer)Matchers.any());
    }

    @Test
    public void testAddMarshallingStrategy() {
        this.deploymentsSectionPresenter.addMarshallingStrategy("Name");
        ((DeploymentsSectionPresenter.MarshallingStrategiesListPresenter)Mockito.verify((Object)this.marshallingStrategyPresenters)).add(Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }

    @Test
    public void testAddEventListener() {
        this.deploymentsSectionPresenter.addEventListener("Name");
        ((DeploymentsSectionPresenter.EventListenersListPresenter)Mockito.verify((Object)this.eventListenerPresenters)).add(Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }

    @Test
    public void testAddGlobal() {
        this.deploymentsSectionPresenter.addGlobal("Name", "Value");
        ((DeploymentsSectionPresenter.GlobalsListPresenter)Mockito.verify((Object)this.globalPresenters)).add(Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }

    @Test
    public void testAddRequiredRole() {
        this.deploymentsSectionPresenter.addRequiredRole("Name");
        ((DeploymentsSectionPresenter.RequiredRolesListPresenter)Mockito.verify((Object)this.requiredRolePresenters)).add(Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }

    @Test
    public void testSave() {
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.deploymentsSectionPresenter)).save((String)Matchers.eq((Object)"Test comment"));
        this.deploymentsSectionPresenter.save("Test comment", null).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).save((String)Matchers.eq((Object)"Test comment"));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter, (VerificationMode)Mockito.never())).setup();
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testSaveWithConcurrentUpdate() {
        this.deploymentsSectionPresenter.concurrentDeploymentsXmlUpdateInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
        ((DeploymentsSectionPresenter)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.deploymentsSectionPresenter)).setup();
        this.deploymentsSectionPresenter.save("Test comment", null).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter, (VerificationMode)Mockito.never())).save((String)Matchers.any());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).setup();
        ((Event)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testSaveModel() {
        ((DDEditorService)Mockito.doReturn((Object)Mockito.mock(Path.class)).when((Object)this.ddEditorService)).save((Path)Matchers.any(), Matchers.any(), (Metadata)Matchers.any(), (String)Matchers.any());
        DeploymentDescriptorModel model = new DeploymentDescriptorModel();
        model.setOverview(new Overview());
        this.deploymentsSectionPresenter.model = model;
        this.deploymentsSectionPresenter.save("Test comment").catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((DDEditorService)Mockito.verify((Object)this.ddEditorService)).save((Path)Matchers.any(), Matchers.any(), (Metadata)Matchers.any(), (String)Matchers.eq((Object)"Test comment"));
    }

    @Test
    public void testNewObjectItemModel() {
        ItemObjectModel model = this.deploymentsSectionPresenter.newObjectModelItem("Value");
        Assert.assertEquals((Object)"Value", (Object)model.getValue());
        Assert.assertEquals((Object)"mvel", (Object)model.getResolver());
        Assert.assertTrue((boolean)model.getParameters().isEmpty());
    }

    @Test
    public void testNewNamedObjectItemModel() {
        ItemObjectModel model = this.deploymentsSectionPresenter.newNamedObjectModelItem("Name", "Value");
        Assert.assertEquals((Object)"Name", (Object)model.getName());
        Assert.assertEquals((Object)"Value", (Object)model.getValue());
        Assert.assertEquals((Object)"mvel", (Object)model.getResolver());
        Assert.assertTrue((boolean)model.getParameters().isEmpty());
    }

    @Test
    public void testSetPersistenceUnitName() {
        DeploymentDescriptorModel model;
        this.deploymentsSectionPresenter.model = model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setPersistenceUnitName("Name");
        Assert.assertEquals((Object)"Name", (Object)model.getPersistenceUnitName());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }

    @Test
    public void testSetAuditPersistenceUnitName() {
        DeploymentDescriptorModel model;
        this.deploymentsSectionPresenter.model = model = new DeploymentDescriptorModel();
        this.deploymentsSectionPresenter.setAuditPersistenceUnitName("Name");
        Assert.assertEquals((Object)"Name", (Object)model.getAuditPersistenceUnitName());
        ((DeploymentsSectionPresenter)Mockito.verify((Object)this.deploymentsSectionPresenter)).fireChangeEvent();
    }
}

