/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.items;

import elemental2.dom.Element;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ParametersModal;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.Resolver;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.kie.workbench.common.screens.library.client.settings.util.KieEnumSelectElement;
import org.kie.workbench.common.screens.library.client.settings.util.ListItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.UberElementalListItem;

@Dependent
public class ObjectItemPresenter
extends ListItemPresenter<ItemObjectModel, DeploymentsSectionPresenter, View>
implements ObjectPresenter {
    private final ParametersModal parametersModal;
    private final KieEnumSelectElement<Resolver> resolversSelect;
    ItemObjectModel model;
    DeploymentsSectionPresenter parentPresenter;

    @Inject
    public ObjectItemPresenter(View view, ParametersModal parametersModal, KieEnumSelectElement<Resolver> resolversSelect) {
        super((UberElementalListItem)view);
        this.parametersModal = parametersModal;
        this.resolversSelect = resolversSelect;
    }

    public ObjectItemPresenter setup(ItemObjectModel model, DeploymentsSectionPresenter parentPresenter) {
        this.model = model;
        this.parentPresenter = parentPresenter;
        if (model.getParameters() == null) {
            model.setParameters(new ArrayList());
        }
        this.parametersModal.setup(model.getParameters(), this);
        this.resolversSelect.setup(((View)this.view).getResolversContainer(), (Enum[])Resolver.values(), (Enum)Resolver.valueOf(model.getResolver().toUpperCase()), resolver -> {
            model.setResolver(resolver.name().toLowerCase());
            parentPresenter.fireChangeEvent();
        });
        ((View)this.view).init(this);
        ((View)this.view).setValue(model.getValue());
        ((View)this.view).setParametersCount(model.getParameters().size());
        return this;
    }

    public void remove() {
        super.remove();
        this.fireChangeEvent();
    }

    @Override
    public void fireChangeEvent() {
        this.parentPresenter.fireChangeEvent();
    }

    public void showParametersModal() {
        this.parametersModal.show();
    }

    public ItemObjectModel getObject() {
        return this.model;
    }

    @Override
    public void signalParameterAddedOrRemoved() {
        ((View)this.view).setParametersCount(this.model.getParameters().size());
        this.fireChangeEvent();
    }

    public static interface View
    extends UberElementalListItem<ObjectItemPresenter> {
        public Element getResolversContainer();

        public void setValue(String var1);

        public void setParametersCount(int var1);
    }
}

