/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.wi.casemgmt.service.CaseProjectService;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.kie.workbench.common.screens.library.api.preferences.LibraryPreferences;
import org.kie.workbench.common.screens.projecteditor.client.resources.ProjectEditorResources;
import org.kie.workbench.common.screens.projecteditor.client.wizard.NewWorkspaceProjectWizard;
import org.kie.workbench.common.screens.projecteditor.client.wizard.POMBuilder;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewWorkspaceProjectHandler;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.type.AnyResourceTypeDefinition;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
public class NewCaseProjectHandler
implements NewWorkspaceProjectHandler {
    private WorkspaceProjectContext context;
    private NewWorkspaceProjectWizard wizard;
    private ProjectController projectController;
    private AnyResourceTypeDefinition resourceType;
    private Caller<CaseProjectService> caseProjectService;
    private Event<NotificationEvent> notification;
    private boolean openEditorOnCreation = true;
    private org.uberfire.client.callbacks.Callback<WorkspaceProject> creationSuccessCallback;
    org.uberfire.client.callbacks.Callback<WorkspaceProject> configureCaseProjectCallback = new org.uberfire.client.callbacks.Callback<WorkspaceProject>(){

        public void callback(final WorkspaceProject project) {
            if (project != null) {
                ((CaseProjectService)NewCaseProjectHandler.this.caseProjectService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        NewCaseProjectHandler.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.ConfigureProjectSuccess(project.getName()), NotificationEvent.NotificationType.SUCCESS));
                        if (NewCaseProjectHandler.this.creationSuccessCallback != null) {
                            NewCaseProjectHandler.this.creationSuccessCallback.callback((Object)project);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback(){

                    public boolean error(Message message, Throwable throwable) {
                        NewCaseProjectHandler.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.ConfigureProjectFailure(project.getName()), NotificationEvent.NotificationType.ERROR));
                        return super.error(message, throwable);
                    }
                })).configureNewCaseProject(project);
            }
        }
    };
    private Event<WorkspaceProjectContextChangeEvent> projectContextChangeEventEvent;
    private LibraryPreferences libraryPreferences;
    private Caller<OrganizationalUnitService> ouService;

    public NewCaseProjectHandler() {
    }

    @Inject
    public NewCaseProjectHandler(WorkspaceProjectContext context, Event<WorkspaceProjectContextChangeEvent> projectContextChangeEventEvent, LibraryPreferences libraryPreferences, NewWorkspaceProjectWizard wizard, Caller<OrganizationalUnitService> ouService, ProjectController projectController, AnyResourceTypeDefinition resourceType) {
        this.context = context;
        this.projectContextChangeEventEvent = projectContextChangeEventEvent;
        this.libraryPreferences = libraryPreferences;
        this.ouService = ouService;
        this.wizard = wizard;
        this.projectController = projectController;
        this.resourceType = resourceType;
    }

    @Inject
    public void setCaseProjectService(Caller<CaseProjectService> caseProjectService) {
        this.caseProjectService = caseProjectService;
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        return Collections.emptyList();
    }

    public String getDescription() {
        return Constants.INSTANCE.CaseProject();
    }

    public IsWidget getIcon() {
        return new Image(ProjectEditorResources.INSTANCE.newProjectIcon());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public boolean canCreate() {
        return this.projectController.canCreateProjects();
    }

    public void create(Package pkg, String projectName, NewResourcePresenter presenter) {
        throw new UnsupportedOperationException();
    }

    public void validate(String projectName, ValidatorWithReasonCallback callback) {
        throw new UnsupportedOperationException();
    }

    public void acceptContext(Callback<Boolean, Void> response) {
        response.onSuccess((Object)true);
    }

    public Command getCommand(NewResourcePresenter newResourcePresenter) {
        return new Command(){

            public void execute() {
                if (!NewCaseProjectHandler.this.context.getActiveOrganizationalUnit().isPresent()) {
                    ((OrganizationalUnitService)NewCaseProjectHandler.this.ouService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

                        public void callback(OrganizationalUnit organizationalUnit) {
                            NewCaseProjectHandler.this.projectContextChangeEventEvent.fire((Object)new WorkspaceProjectContextChangeEvent(organizationalUnit));
                            NewCaseProjectHandler.this.init();
                        }
                    })).getOrganizationalUnit(NewCaseProjectHandler.this.libraryPreferences.getOrganizationalUnitPreferences().getName());
                } else {
                    NewCaseProjectHandler.this.init();
                }
            }
        };
    }

    private void init() {
        this.wizard.initialise(new POMBuilder().setModuleName("").setGroupId(((OrganizationalUnit)this.context.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot initialize new case project without an active organizational unit."))).getDefaultGroupId()).build());
        this.wizard.start(this.creationSuccessCallback, this.openEditorOnCreation);
    }

    public void setCreationSuccessCallback(org.uberfire.client.callbacks.Callback<WorkspaceProject> creationSuccessCallback) {
        this.creationSuccessCallback = creationSuccessCallback;
    }

    public void setOpenEditorOnCreation(boolean openEditorOnCreation) {
        this.openEditorOnCreation = openEditorOnCreation;
    }
}

