/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.items;

import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ParametersModal;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;
import org.kie.workbench.common.widgets.client.widget.ListItemView;

@Dependent
public class NamedObjectItemPresenter
extends ListItemPresenter<ItemObjectModel, Section<?>, View>
implements ObjectPresenter {
    private final ParametersModal parametersModal;
    ItemObjectModel model;
    Section<?> parentPresenter;

    @Inject
    public NamedObjectItemPresenter(View view, ParametersModal parametersModal) {
        super((ListItemView)view);
        this.parametersModal = parametersModal;
    }

    public NamedObjectItemPresenter setup(ItemObjectModel model, Section<?> parentPresenter) {
        this.model = model;
        this.parentPresenter = parentPresenter;
        if (model.getParameters() == null) {
            model.setParameters(new ArrayList());
        }
        this.parametersModal.setup(model.getParameters(), this);
        ((View)this.view).setupResolverSelect(model, parentPresenter);
        ((View)this.view).init(this);
        ((View)this.view).setName(model.getName());
        ((View)this.view).setValue(model.getValue());
        ((View)this.view).setParametersCount(model.getParameters().size());
        return this;
    }

    public void remove() {
        super.remove();
        this.fireChangeEvent();
    }

    public void onNameChange(String name) {
        this.model.setName(name);
        this.fireChangeEvent();
    }

    public void onValueChange(String value) {
        this.model.setValue(value);
        this.fireChangeEvent();
    }

    @Override
    public void fireChangeEvent() {
        this.parentPresenter.fireChangeEvent();
    }

    public void showParametersModal() {
        this.parametersModal.show();
    }

    public ItemObjectModel getObject() {
        return this.model;
    }

    @Override
    public void signalParameterAddedOrRemoved() {
        ((View)this.view).setParametersCount(this.model.getParameters().size());
        this.fireChangeEvent();
    }

    public static interface View
    extends ListItemView<NamedObjectItemPresenter> {
        public void setName(String var1);

        public void setValue(String var1);

        public void setParametersCount(int var1);

        public void setupResolverSelect(ItemObjectModel var1, Section<?> var2);
    }
}

