/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwt.event.dom.client.ChangeEvent;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.ToggleSwitch;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.base.constants.SizeType;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskViewImpl;
import org.jbpm.workbench.wi.client.workitem.ServiceTasksRepositoryListPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.jbpm.workbench.wi.workitems.model.ServiceTasksConfiguration;
import org.uberfire.client.views.pfly.widgets.FormGroup;

@Dependent
@Templated
public class ServiceTasksRepositoryListViewImpl
extends AbstractView<ServiceTasksRepositoryListPresenter>
implements ServiceTasksRepositoryListPresenter.ServiceTasksRepositoryListView {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="list-view")
    private Div viewContainer;
    @Inject
    @DataField(value="maven-install-group")
    private FormGroup mavenInstallGroup;
    @Inject
    @DataField(value="maven-install-help")
    private Span mavenInstalHelp;
    @Inject
    @DataField(value="maven-install")
    private ToggleSwitch mavenInstall;
    @Inject
    @DataField(value="install-pom-deps-group")
    private FormGroup installPomDepsGroup;
    @Inject
    @DataField(value="install-pom-deps-help")
    private Span installPomDepsHelp;
    @Inject
    @DataField(value="install-pom-deps")
    private ToggleSwitch installPomDeps;
    @Inject
    @DataField(value="use-version-range-group")
    private FormGroup useVersionRangeGroup;
    @Inject
    @DataField(value="use-version-range-help")
    private Span useVersionRangeHelp;
    @Inject
    @DataField(value="use-version-range")
    private ToggleSwitch useVersionRange;
    @Inject
    @AutoBound
    private DataBinder<List<ServiceTaskSummary>> serviceTaskList;
    @Inject
    @Bound
    @DataField(value="list-container")
    private ListComponent<ServiceTaskSummary, ServiceTaskViewImpl> list;

    public void init(ServiceTasksRepositoryListPresenter presenter) {
        super.init((Object)presenter);
        this.list.addComponentCreationHandler(v -> v.init(presenter));
        this.mavenInstall.setSize(SizeType.MINI);
        this.installPomDeps.setSize(SizeType.MINI);
        this.useVersionRange.setSize(SizeType.MINI);
        this.mavenInstalHelp.setTextContent(this.constants.MavenInstallHelp());
        this.installPomDepsHelp.setTextContent(this.constants.InstallPomDepsHelp());
        this.useVersionRangeHelp.setTextContent(this.constants.UseVersionRangeHelp());
    }

    @Override
    public void setServiceTaskList(List<ServiceTaskSummary> serviceTaskList) {
        this.serviceTaskList.setModel(serviceTaskList);
        if (serviceTaskList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
    }

    public HTMLElement getElement() {
        return this.viewContainer;
    }

    @EventHandler(value={"add-service-task"})
    public void onAddServiceTaskClick(@ForEvent(value={"click"}) MouseEvent event) {
        ((ServiceTasksRepositoryListPresenter)this.presenter).openUploadDialog();
    }

    @EventHandler(value={"maven-install"})
    public void onToggleChangeMavenInstall(ChangeEvent event) {
        this.updateConfiguration();
    }

    @EventHandler(value={"install-pom-deps"})
    public void onToggleChangeInstallPomDeps(ChangeEvent event) {
        this.updateConfiguration();
    }

    @EventHandler(value={"use-version-range"})
    public void onToggleChangeVersionRange(ChangeEvent event) {
        this.updateConfiguration();
    }

    protected void updateConfiguration() {
        ServiceTasksConfiguration configuration = new ServiceTasksConfiguration(this.mavenInstall.getValue(), this.installPomDeps.getValue(), this.useVersionRange.getValue());
        ((ServiceTasksRepositoryListPresenter)this.presenter).saveConfiguration(configuration);
    }

    @Override
    public void setConfiguration(ServiceTasksConfiguration configuration) {
        this.mavenInstall.setValue(configuration.getMavenInstall(), false);
        this.installPomDeps.setValue(configuration.getInstallPomDeps(), false);
        this.useVersionRange.setValue(configuration.getVersionRange(), false);
    }
}

