/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.apache.commons.io.FilenameUtils;

@RunWith(value=Arquillian.class)
public class DeploymentIT {
    public static final String ARCHIVE_NAME = "wildfly.war";

    @Deployment(testable=false)
    public static WebArchive create() {
        String warFile = System.getProperty(ARCHIVE_NAME);
        return (WebArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)warFile)).importFrom(new File("target/" + warFile))).as(WebArchive.class);
    }

    @Test
    @RunAsClient
    public void testShowcaseDeployment(@ArquillianResource URL baseURL) throws Exception {
        HttpURLConnection c = null;
        try {
            c = (HttpURLConnection)baseURL.openConnection();
            Assert.assertEquals((long)200L, (long)c.getResponseCode());
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    @RunAsClient
    public void testCaseManagementDeployment(@ArquillianResource URL baseURL) throws Exception {
        URL cm = new URL(baseURL, this.getCaseAppContext());
        while (true) {
            HttpURLConnection c = null;
            try {
                c = (HttpURLConnection)cm.openConnection();
                if (c.getResponseCode() == 200) break;
                Thread.sleep(500L);
                continue;
            }
            finally {
                if (c == null) continue;
                c.disconnect();
                continue;
            }
            break;
        }
    }

    private String getCaseAppContext() {
        String showcaseGAV = this.loadShowcaseGAV();
        File file = ((MavenFormatStage)((MavenStrategyStage)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline()).resolve(showcaseGAV)).withoutTransitivity()).asSingleFile();
        return "/" + FilenameUtils.getBaseName((String)file.getName());
    }

    private String loadShowcaseGAV() {
        Properties properties = new Properties();
        try (InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream("casemgmt.properties");){
            properties.load(resource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return properties.getProperty("showcase.gav");
    }
}

