/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.client.ShowcaseEntryPoint;
import org.jbpm.workbench.client.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.ConstantsAnswerMock;
import org.uberfire.mocks.IocTestingUtils;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class ShowcaseEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    private CallerMock<AppConfigService> appConfigServiceCallerMock;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private User identity;
    @Mock
    private DefaultAdminPageHelper adminPageHelper;
    @Spy
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    private WorkbenchMegaMenuPresenter menuBar;
    private ShowcaseEntryPoint showcaseEntryPoint;

    @Before
    public void setup() {
        this.appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.showcaseEntryPoint = (ShowcaseEntryPoint)Mockito.spy((Object)new ShowcaseEntryPoint(this.appConfigServiceCallerMock, this.activityBeansCache, this.iocManager, this.identity, this.adminPageHelper, this.menusHelper, this.menuBar));
        this.mockMenuHelper();
        this.mockConstants();
        IocTestingUtils.mockIocManager((SyncBeanManager)this.iocManager);
    }

    @Test
    public void setupMenuTest() {
        this.showcaseEntryPoint.setupMenu();
        ArgumentCaptor menusCaptor = ArgumentCaptor.forClass(Menus.class);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)menusCaptor.capture());
        Menus menus = (Menus)menusCaptor.getValue();
        Assert.assertEquals((long)6L, (long)menus.getItems().size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Authoring(), (Object)((MenuItem)menus.getItems().get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Deploy(), (Object)((MenuItem)menus.getItems().get(1)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Process_Management(), (Object)((MenuItem)menus.getItems().get(2)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Work(), (Object)((MenuItem)menus.getItems().get(3)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Dashboards(), (Object)((MenuItem)menus.getItems().get(4)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Extensions(), (Object)((MenuItem)menus.getItems().get(5)).getCaption());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addRolesMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addGroupsMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchConfigurationMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
    }

    @Test
    public void getAuthoringViewsTest() {
        List authoringMenuItems = this.showcaseEntryPoint.getAuthoringViews();
        Assert.assertEquals((long)3L, (long)authoringMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Project_Authoring(), (Object)((MenuItem)authoringMenuItems.get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.artifactRepository(), (Object)((MenuItem)authoringMenuItems.get(1)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Administration(), (Object)((MenuItem)authoringMenuItems.get(2)).getCaption());
    }

    @Test
    public void getProcessManagementViewsTest() {
        List processManagementMenuItems = this.showcaseEntryPoint.getProcessManagementViews();
        Assert.assertEquals((long)5L, (long)processManagementMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.Process_Definitions(), (Object)((MenuItem)processManagementMenuItems.get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.Process_Instances(), (Object)((MenuItem)processManagementMenuItems.get(1)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Process_Instances_Admin(), (Object)((MenuItem)processManagementMenuItems.get(2)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.Tasks(), (Object)((MenuItem)processManagementMenuItems.get(3)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.ExecutionErrors(), (Object)((MenuItem)processManagementMenuItems.get(4)).getCaption());
    }

    @Test
    public void getDeploymentViewsTest() {
        List deploymentMenuItems = this.showcaseEntryPoint.getDeploymentViews();
        Assert.assertEquals((long)2L, (long)deploymentMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Execution_Servers(), (Object)((MenuItem)deploymentMenuItems.get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.Jobs(), (Object)((MenuItem)deploymentMenuItems.get(1)).getCaption());
    }

    @Test
    public void getWorkViewsTest() {
        List workMenuItems = this.showcaseEntryPoint.getWorkViews();
        Assert.assertEquals((long)3L, (long)workMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.commonConstants.Task_Inbox(), (Object)((MenuItem)workMenuItems.get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Tasks_List_Admin(), (Object)((MenuItem)workMenuItems.get(1)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Data_Sets(), (Object)((MenuItem)workMenuItems.get(2)).getCaption());
    }

    @Test
    public void getDashboardsViewsTest() {
        List dashboardsMenuItems = this.showcaseEntryPoint.getDashboardsViews();
        Assert.assertEquals((long)2L, (long)dashboardsMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Process_Reports(), (Object)((MenuItem)dashboardsMenuItems.get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.Task_Reports(), (Object)((MenuItem)dashboardsMenuItems.get(1)).getCaption());
    }

    private void mockMenuHelper() {
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(Collections.emptyList()).when((Object)this.menusHelper)).getRoles();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(Collections.emptyList()).when((Object)this.menusHelper)).getGroups();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doNothing().when((Object)this.menusHelper)).addWorkbenchConfigurationMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doNothing().when((Object)this.menusHelper)).addUtilitiesMenuItems();
    }

    private void mockConstants() {
        this.showcaseEntryPoint.constants = (Constants)Mockito.mock(Constants.class, (Answer)new ConstantsAnswerMock());
    }
}

