/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench;

import java.net.HttpURLConnection;
import java.net.URL;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;

public class DeploymentIT {
    public static final int TIMEOUT = 60000;

    @Test(timeout=60000L)
    public void testShowcaseDeployment() throws Exception {
        URL baseURL = new URL("http://localhost:8080/jbpm-wb-showcase/");
        HttpURLConnection c = null;
        try {
            c = (HttpURLConnection)baseURL.openConnection();
            Assert.assertEquals((long)200L, (long)c.getResponseCode());
        }
        finally {
            if (c != null) {
                c.disconnect();
            }
        }
    }

    @Test(timeout=60000L)
    public void testCaseManagementDeployment() throws Exception {
        String context = System.getProperty("case-mgmt-showcase.context");
        Assert.assertNotNull((Object)context);
        URL cm = new URL("http://localhost:8080/" + context);
        Awaitility.await().atMost(Duration.ONE_MINUTE).untilAsserted(() -> {
            HttpURLConnection c = null;
            try {
                c = (HttpURLConnection)cm.openConnection();
                Assert.assertEquals((long)200L, (long)c.getResponseCode());
            }
            finally {
                if (c != null) {
                    c.disconnect();
                }
            }
        });
    }

    @Test(timeout=60000L)
    public void testCustomQueriesDeployedToKieServer() throws Exception {
        URL baseURL = new URL("http://localhost:8080/kie-server/");
        String url = new URL(baseURL, "services/rest/server").toString();
        KieServicesClient client = KieServerUtils.createKieServicesClient((String)url, null, (String)"kieserver", (String)"kieserver1!", null);
        QueryServicesClient queryServicesClient = (QueryServicesClient)client.getServicesClient(QueryServicesClient.class);
        this.assertQueryDefinition(queryServicesClient, "jbpmProcessInstances");
        this.assertQueryDefinition(queryServicesClient, "jbpmProcessInstancesWithVariables");
        this.assertQueryDefinition(queryServicesClient, "processesMonitoring");
        this.assertQueryDefinition(queryServicesClient, "tasksMonitoring");
        this.assertQueryDefinition(queryServicesClient, "jbpmRequestList");
        this.assertQueryDefinition(queryServicesClient, "jbpmExecutionErrorList");
        this.assertQueryDefinition(queryServicesClient, "jbpmHumanTasks");
        this.assertQueryDefinition(queryServicesClient, "jbpmHumanTasksWithUser");
        this.assertQueryDefinition(queryServicesClient, "jbpmHumanTasksWithAdmin");
        this.assertQueryDefinition(queryServicesClient, "jbpmHumanTasksWithVariables");
    }

    private void assertQueryDefinition(QueryServicesClient client, String name) {
        QueryDefinition qd = client.getQuery(name);
        Assert.assertNotNull((Object)qd);
    }
}

