/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.backend.server.dd;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.console.ng.wi.backend.server.dd.DDConfigUpdaterHelper;
import org.jbpm.console.ng.wi.backend.server.dd.DDEditorServiceImpl;
import org.jbpm.console.ng.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.console.ng.wi.dd.model.ItemObjectModel;
import org.jbpm.console.ng.wi.dd.service.DDEditorService;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class DDConfigUpdater {
    private KieProjectService projectService;
    private IOService ioService;
    private DDEditorService ddEditorService;
    private DDConfigUpdaterHelper configUpdaterHelper;
    private static final String MVEL_PREFIX = "mvel:";
    private static final String REFLECTION_PREFIX = "reflection:";
    private static final String DEFAULT_RESOLVER = "reflection";

    public DDConfigUpdater() {
    }

    @Inject
    public DDConfigUpdater(DDEditorService ddEditorService, KieProjectService projectService, @Named(value="ioStrategy") IOService ioService, DDConfigUpdaterHelper configUpdaterHelper) {
        this.ddEditorService = ddEditorService;
        this.projectService = projectService;
        this.ioService = ioService;
        this.configUpdaterHelper = configUpdaterHelper;
    }

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        if (this.configUpdaterHelper.isPersistenceFile(resourceAddedEvent.getPath())) {
            this.updateConfig((KieProject)this.projectService.resolveProject(resourceAddedEvent.getPath()));
        }
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        if (this.configUpdaterHelper.isPersistenceFile(resourceUpdatedEvent.getPath())) {
            this.updateConfig((KieProject)this.projectService.resolveProject(resourceUpdatedEvent.getPath()));
        }
    }

    public void processWorkitemInstall(@Observes DesignerWorkitemInstalledEvent workitemInstalledEvent) {
        this.addWorkItemToConfig((KieProject)this.projectService.resolveProject(workitemInstalledEvent.getPath()), workitemInstalledEvent);
    }

    private void addWorkItemToConfig(KieProject kieProject, DesignerWorkitemInstalledEvent workitemInstalledEvent) {
        DeploymentDescriptorModel descriptorModel;
        Path deploymentDescriptorPath = this.getDeploymentDescriptorPath(kieProject);
        if (this.ioService.exists(Paths.convert((Path)deploymentDescriptorPath)) && (descriptorModel = (DeploymentDescriptorModel)this.ddEditorService.load(deploymentDescriptorPath)) != null) {
            if (descriptorModel.getWorkItemHandlers() == null) {
                descriptorModel.setWorkItemHandlers(new ArrayList());
            }
            if (this.isValidWorkitem(workitemInstalledEvent) && !this.workItemAlreadyInstalled(descriptorModel.getWorkItemHandlers(), workitemInstalledEvent.getName())) {
                ItemObjectModel itemModel = new ItemObjectModel(workitemInstalledEvent.getName(), this.parseWorkitemValue(workitemInstalledEvent.getValue()), this.getWorkitemResolver(workitemInstalledEvent.getValue(), workitemInstalledEvent.getResolver()), null);
                descriptorModel.getWorkItemHandlers().add(itemModel);
                CommentedOption commentedOption = new CommentedOption("system", null, "Workitem config added by system.", new Date());
                ((DDEditorServiceImpl)this.ddEditorService).save(deploymentDescriptorPath, descriptorModel, descriptorModel.getOverview().getMetadata(), commentedOption);
            }
        }
    }

    public String parseWorkitemValue(String value) {
        if (value.trim().toLowerCase().startsWith(MVEL_PREFIX)) {
            return value.trim().substring(MVEL_PREFIX.length()).trim();
        }
        if (value.trim().toLowerCase().startsWith(REFLECTION_PREFIX)) {
            return value.trim().substring(REFLECTION_PREFIX.length()).trim();
        }
        return value.trim();
    }

    public String getWorkitemResolver(String value, String defaultResolver) {
        if (value.trim().toLowerCase().startsWith(MVEL_PREFIX)) {
            return MVEL_PREFIX.substring(0, MVEL_PREFIX.length() - 1);
        }
        if (value.trim().toLowerCase().startsWith(REFLECTION_PREFIX)) {
            return REFLECTION_PREFIX.substring(0, REFLECTION_PREFIX.length() - 1);
        }
        if (defaultResolver == null || defaultResolver.trim().isEmpty()) {
            return DEFAULT_RESOLVER;
        }
        return defaultResolver;
    }

    public boolean isValidWorkitem(DesignerWorkitemInstalledEvent workitemInstalledEvent) {
        return workitemInstalledEvent != null && workitemInstalledEvent.getName() != null && workitemInstalledEvent.getName().trim().length() > 0 && workitemInstalledEvent.getValue() != null && workitemInstalledEvent.getValue().trim().length() > 0;
    }

    private boolean workItemAlreadyInstalled(List<ItemObjectModel> workitemHandlers, String name) {
        if (name == null || name.trim().length() < 1) {
            return false;
        }
        for (ItemObjectModel itemObject : workitemHandlers) {
            if (itemObject == null || !itemObject.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void updateConfig(KieProject kieProject) {
        Path deploymentDescriptorPath = this.getDeploymentDescriptorPath(kieProject);
        if (this.ioService.exists(Paths.convert((Path)deploymentDescriptorPath))) {
            DeploymentDescriptorModel descriptorModel = (DeploymentDescriptorModel)this.ddEditorService.load(deploymentDescriptorPath);
            this.updateMarshallingConfig(descriptorModel, deploymentDescriptorPath, kieProject);
        }
    }

    private Path getDeploymentDescriptorPath(KieProject kieProject) {
        return PathFactory.newPath((String)"kie-deployment-descriptor.xml", (String)(kieProject.getRootPath().toURI() + "/src/main/resources/META-INF/kie-deployment-descriptor.xml"));
    }

    private void updateMarshallingConfig(DeploymentDescriptorModel descriptorModel, Path path, KieProject kieProject) {
        String marshallingValue = this.configUpdaterHelper.buildJPAMarshallingStrategyValue(kieProject);
        if (marshallingValue != null && descriptorModel != null) {
            ItemObjectModel oldMarshallingStrategy = null;
            if (descriptorModel.getMarshallingStrategies() != null) {
                for (ItemObjectModel itemModel : descriptorModel.getMarshallingStrategies()) {
                    if (itemModel.getValue() == null || !itemModel.getValue().contains("org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy")) continue;
                    oldMarshallingStrategy = itemModel;
                    break;
                }
                if (oldMarshallingStrategy != null) {
                    descriptorModel.getMarshallingStrategies().remove(oldMarshallingStrategy);
                }
            } else {
                descriptorModel.setMarshallingStrategies(new ArrayList());
            }
            ItemObjectModel marshallingStrategy = new ItemObjectModel();
            marshallingStrategy.setResolver("mvel");
            marshallingStrategy.setValue(marshallingValue);
            descriptorModel.getMarshallingStrategies().add(marshallingStrategy);
            CommentedOption commentedOption = new CommentedOption("system", null, "JPA marshalling strategy added by system", new Date());
            ((DDEditorServiceImpl)this.ddEditorService).save(path, descriptorModel, descriptorModel.getOverview().getMetadata(), commentedOption);
        }
    }
}

