/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.email.EmailNotificationPublisher;
import org.jbpm.process.workitem.email.TemplateManager;
import org.jbpm.services.task.identity.DefaultUserInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.ClassLoaderUtil;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class EmailNotificationPublisherTest {
    private Wiser wiser;
    private String emailHost;
    private String emailPort;
    private Connection connection;
    private UserInfo userInfo;
    private TaskModelFactory factory = TaskModelProvider.getFactory();

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.jbpm.email.templates.dir", new File("src/test/resources/templates").getAbsolutePath());
        TemplateManager.reset();
        ChainedProperties props = ChainedProperties.getChainedProperties((String)"email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        this.emailHost = props.getProperty("mail.smtp.host", "localhost");
        this.emailPort = props.getProperty("mail.smtp.port", "2345");
        this.wiser = new Wiser();
        this.wiser.setHostname(this.emailHost);
        this.wiser.setPort(Integer.parseInt(this.emailPort));
        this.wiser.start();
        Thread.sleep(200L);
        this.connection = new Connection(this.emailHost, this.emailPort);
        this.userInfo = new DefaultUserInfo(true);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("org.jbpm.email.templates.dir");
        if (this.wiser != null) {
            this.wiser.getMessages().clear();
            this.wiser.stop();
            this.wiser = null;
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testGetEntityForEmail() {
        String entityId = this.userInfo.getEntityForEmail("mary@domain.com");
        Assert.assertEquals((Object)"mary", (Object)entityId);
    }

    @Test
    public void testEmailNotificationWithoutTemplate() throws Exception {
        EmailNotificationPublisher publisher = new EmailNotificationPublisher(this.connection, this.userInfo);
        HashSet<User> recipients = new HashSet<User>(Arrays.asList(this.factory.newUser("john")));
        publisher.publish("admin@jbpm.org", "Test notification", recipients, "Test body");
        Assert.assertEquals((long)1L, (long)this.wiser.getMessages().size());
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)"Test body", (Object)content);
        Assert.assertEquals((Object)"Test notification", (Object)msg.getSubject());
        Assert.assertEquals((Object)"admin@jbpm.org", (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"john@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }

    @Test
    public void testEmailNotificationWithTemplate() throws Exception {
        EmailNotificationPublisher publisher = new EmailNotificationPublisher(this.connection, this.userInfo);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Name", "John Doe");
        HashSet<User> recipients = new HashSet<User>(Arrays.asList(this.factory.newUser("john")));
        publisher.publish("admin@jbpm.org", "Test notification", recipients, "basic-email", parameters);
        Assert.assertEquals((long)1L, (long)this.wiser.getMessages().size());
        String expectedBody = "<html><body>Hello John Doe</body></html>";
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)expectedBody, (Object)content);
        Assert.assertEquals((Object)"Test notification", (Object)msg.getSubject());
        Assert.assertEquals((Object)"admin@jbpm.org", (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"john@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }

    @Test
    public void testEmailNotificationWithoutTemplateToGroup() throws Exception {
        EmailNotificationPublisher publisher = new EmailNotificationPublisher(this.connection, this.userInfo);
        HashSet<Group> recipients = new HashSet<Group>(Arrays.asList(this.factory.newGroup("managers")));
        publisher.publish("admin@jbpm.org", "Test notification", recipients, "Test body");
        Assert.assertEquals((long)1L, (long)this.wiser.getMessages().size());
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)"Test body", (Object)content);
        Assert.assertEquals((Object)"Test notification", (Object)msg.getSubject());
        Assert.assertEquals((Object)"admin@jbpm.org", (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"john@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }

    @Test
    public void testEmailNotificationWithoutTemplateToMultipleRecipients() throws Exception {
        EmailNotificationPublisher publisher = new EmailNotificationPublisher(this.connection, this.userInfo);
        LinkedHashSet<OrganizationalEntity> recipients = new LinkedHashSet<OrganizationalEntity>(Arrays.asList(this.factory.newGroup("managers"), this.factory.newUser("mary")));
        publisher.publish("admin@jbpm.org", "Test notification", recipients, "Test body");
        Assert.assertEquals((long)2L, (long)this.wiser.getMessages().size());
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)"Test body", (Object)content);
        Assert.assertEquals((Object)"Test notification", (Object)msg.getSubject());
        Assert.assertEquals((Object)"admin@jbpm.org", (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)"john@domain.com", (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }
}

