/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.email.Email;
import org.jbpm.process.workitem.email.Message;
import org.jbpm.process.workitem.email.Recipient;
import org.jbpm.process.workitem.email.Recipients;
import org.jbpm.process.workitem.email.SendHtml;
import org.jbpm.process.workitem.email.TemplateManager;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.utils.NotificationPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotificationPublisher
implements NotificationPublisher {
    private static final Logger logger = LoggerFactory.getLogger(EmailNotificationPublisher.class);
    private boolean active = Boolean.parseBoolean(System.getProperty("org.jbpm.email.publisher.enabled", "true"));
    private UserInfo userInfo;
    private Connection connection;
    private TemplateManager templateManager = TemplateManager.get();

    public EmailNotificationPublisher() {
        this.userInfo = UserDataServiceProvider.getUserInfo();
        Properties conf = new Properties();
        try {
            conf.load(this.getClass().getResourceAsStream("/email.properties"));
            this.connection = new Connection();
            this.connection.setHost(conf.getProperty("mail.smtp.host", "localhost"));
            this.connection.setPort(conf.getProperty("mail.smtp.port", "25"));
            this.connection.setUserName(conf.getProperty("mail.username", ""));
            this.connection.setPassword(conf.getProperty("mail.password", ""));
            this.connection.setStartTls(Boolean.parseBoolean(conf.getProperty("mail.tls", "true")));
        }
        catch (Exception e) {
            logger.warn("email.properties was not found on classpath");
        }
    }

    public EmailNotificationPublisher(Connection connection, UserInfo userInfo) {
        this.connection = connection;
        this.userInfo = userInfo;
    }

    public void publish(String sender, String subject, Set<OrganizationalEntity> recipients, String body) {
        Email emailNotification = this.createEmail(sender, subject, recipients, body, this.connection);
        SendHtml.sendHtml(emailNotification, false);
    }

    public void publish(String sender, String subject, Set<OrganizationalEntity> recipients, String template, Map<String, Object> parameters) {
        String body = this.templateManager.render(template, parameters);
        this.publish(sender, subject, recipients, body);
    }

    protected String getEmailAddress(OrganizationalEntity entity) {
        String emailAddress = this.userInfo.getEmailForEntity(entity);
        if (emailAddress != null) {
            return emailAddress;
        }
        return entity.getId();
    }

    protected Email createEmail(String sender, String subject, Set<OrganizationalEntity> recipients, String body, Connection connection) {
        Email email = new Email();
        Message message = new Message();
        message.setFrom(sender);
        LinkedHashSet<String> emailRecipients = new LinkedHashSet<String>();
        for (OrganizationalEntity entity : recipients) {
            this.collectRecipients(emailRecipients, entity);
        }
        Recipients mrecipients = new Recipients();
        if (emailRecipients.isEmpty()) {
            throw new RuntimeException("Email must have one or more recipients");
        }
        for (String recipientAddress : emailRecipients) {
            Recipient recipient = new Recipient();
            recipient.setEmail(recipientAddress);
            recipient.setType("To");
            mrecipients.addRecipient(recipient);
        }
        message.setRecipients(mrecipients);
        message.setSubject(subject);
        message.setBody(body);
        email.setMessage(message);
        email.setConnection(connection);
        return email;
    }

    protected void collectRecipients(Set<String> emailRecipients, OrganizationalEntity entity) {
        Iterator members;
        if (entity instanceof User) {
            String recipientAddress = this.getEmailAddress(entity);
            emailRecipients.add(recipientAddress);
        } else if (entity instanceof Group && (members = this.userInfo.getMembersForGroup((Group)entity)) != null) {
            while (members.hasNext()) {
                OrganizationalEntity member = (OrganizationalEntity)members.next();
                this.collectRecipients(emailRecipients, member);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }
}

