/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager {
    private static final Logger logger = LoggerFactory.getLogger(TemplateManager.class);
    private static TemplateManager INSTANCE = new TemplateManager();
    private StringTemplateLoader stringLoader = new StringTemplateLoader();
    private Configuration cfg;
    private String templateDirectory = System.getProperty("org.jbpm.email.templates.dir");
    private boolean watcherEnabled = Boolean.parseBoolean(System.getProperty("org.jbpm.email.templates.watcher.enabled", "false"));
    private Integer watcherInterval = Integer.parseInt(System.getProperty("org.jbpm.email.templates.watcher.interval", "5"));
    private TemplateDirectoryWatcher watcher;

    protected TemplateManager() {
        this.cfg = new Configuration(Configuration.VERSION_2_3_26);
        this.cfg.setTemplateLoader((TemplateLoader)this.stringLoader);
        this.cfg.setDefaultEncoding("UTF-8");
        this.loadTemplates();
        if (this.watcherEnabled) {
            this.watcher = new TemplateDirectoryWatcher(this.templateDirectory);
            Thread watcherThread = new Thread((Runnable)this.watcher, "Email Template Watch Thread");
            watcherThread.start();
        }
    }

    public static TemplateManager get() {
        return INSTANCE;
    }

    public static synchronized TemplateManager reset() {
        INSTANCE.close();
        INSTANCE = new TemplateManager();
        return INSTANCE;
    }

    public String render(String templateName, Map<String, Object> parameters) {
        StringWriter out = new StringWriter();
        try {
            Template template = this.cfg.getTemplate(templateName);
            template.process(parameters, (Writer)out);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Template " + templateName + " not found", e);
        }
        return out.toString();
    }

    public void registerTemplate(String id, Object template) {
        this.stringLoader.putTemplate(id, template.toString());
    }

    public void unregisterTemplate(String id) {
    }

    protected void loadTemplates() {
        File directory;
        if (this.templateDirectory != null && (directory = new File(this.templateDirectory)).exists() && directory.isDirectory()) {
            File[] foundTemplates;
            for (File templateFile : foundTemplates = directory.listFiles((dir, name) -> name.endsWith(".html"))) {
                this.loadTemplate(templateFile);
            }
        }
    }

    protected void loadTemplate(File templateFile) {
        String templateId = this.resolveTemplateId(templateFile);
        try (FileInputStream inputStream = new FileInputStream(templateFile);){
            this.stringLoader.putTemplate(templateId, this.read(inputStream));
            logger.info("Loaded template {} from file {}", (Object)templateId, (Object)templateFile);
        }
        catch (Exception e) {
            logger.warn("Exception while loading template from {} due to {}", new Object[]{templateFile, e.getMessage(), e});
        }
    }

    protected void removeTemplate(File templateFile) {
        String templateId = this.resolveTemplateId(templateFile);
        this.stringLoader.removeTemplate(templateId);
        logger.info("Removed template {} backed by file {}", (Object)templateId, (Object)templateFile);
    }

    protected String resolveTemplateId(File templateFile) {
        String templateId = templateFile.getName().substring(0, templateFile.getName().lastIndexOf("."));
        return templateId;
    }

    protected String read(InputStream input) {
        String string;
        String lineSeparator = System.getProperty("line.separator");
        BufferedReader buffer = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
        try {
            string = buffer.lines().collect(Collectors.joining(lineSeparator));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        buffer.close();
        return string;
    }

    public void close() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    private class TemplateDirectoryWatcher
    implements Runnable {
        private WatchService watcher;
        private Path toWatch;
        private AtomicBoolean active = new AtomicBoolean(true);

        public TemplateDirectoryWatcher(String configFilePath) {
            this.toWatch = Paths.get(configFilePath, new String[0]);
            try {
                this.watcher = this.toWatch.getFileSystem().newWatchService();
                logger.debug("About to start watching " + this.toWatch.toString());
                this.toWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (Exception e) {
                logger.error("Error when setting up config file watcher :: " + e.getMessage(), (Throwable)e);
                this.active.set(false);
            }
        }

        public void stop() {
            this.active.set(false);
        }

        @Override
        public void run() {
            try {
                while (this.active.get()) {
                    WatchKey key = this.watcher.poll(TemplateManager.this.watcherInterval.intValue(), TimeUnit.SECONDS);
                    if (key == null || !this.active.get()) continue;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path updatedFile = (Path)event.context();
                        File modifiedFile = updatedFile.toFile();
                        if (!modifiedFile.getName().endsWith("html")) continue;
                        if (event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                            logger.debug("Found deleted template file {}, removing it", (Object)modifiedFile);
                            TemplateManager.this.removeTemplate(new File(TemplateManager.this.templateDirectory, modifiedFile.getName()));
                            continue;
                        }
                        logger.debug("Found updated or new template file {}, loading it", (Object)modifiedFile);
                        TemplateManager.this.loadTemplate(new File(TemplateManager.this.templateDirectory, modifiedFile.getName()));
                    }
                    key.reset();
                }
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted exception received...");
            }
        }
    }
}

