/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jbpm.process.workitem.email.TemplateManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManagerTest {
    private static final Logger logger = LoggerFactory.getLogger(TemplateManagerTest.class);
    private TrackingTemplateManager templateManager;
    private File templateDir = new File("src/test/resources/templates");
    private String originalTemplate = "<html><body>Hello ${Name}</body></html>";

    @Before
    public void setup() {
        System.setProperty("org.jbpm.email.templates.watcher.enabled", "true");
        System.setProperty("org.jbpm.email.templates.dir", this.templateDir.getAbsolutePath());
    }

    @After
    public void cleanup() {
        File[] templatesToRemove;
        if (this.templateManager != null) {
            this.templateManager.close();
        }
        for (File template : templatesToRemove = this.templateDir.listFiles((file, name) -> !name.equals("basic-email.html"))) {
            template.delete();
        }
        try {
            Files.write(new File(this.templateDir, "basic-email.html").toPath(), this.originalTemplate.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.debug("Error when restoring basic-email.html template", (Throwable)e);
        }
        System.clearProperty("org.jbpm.email.templates.watcher.enabled");
        System.clearProperty("org.jbpm.email.templates.dir");
    }

    private void configureTemplateManager(CountDownLatch loadTemplate, CountDownLatch removeTemplate) {
        TemplateManager.get().close();
        this.templateManager = new TrackingTemplateManager(loadTemplate, removeTemplate);
    }

    @Test(timeout=30000L)
    public void testLoadNewTemplateFile() throws Exception {
        CountDownLatch loadTemplate = new CountDownLatch(1);
        this.configureTemplateManager(loadTemplate, null);
        String expected = "<html><body>Hello John</body></html>";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Name", "John");
        String rendered = this.templateManager.render("basic-email", parameters);
        Assert.assertEquals((Object)expected, (Object)rendered);
        String advancedTemplate = "<html><body>Hello ${Name}, welcome!</body></html>";
        String expectedAdvanced = "<html><body>Hello John, welcome!</body></html>";
        Thread.sleep(3000L);
        Files.write(new File(this.templateDir, "advanced-email.html").toPath(), advancedTemplate.getBytes(), new OpenOption[0]);
        loadTemplate.await();
        rendered = this.templateManager.render("advanced-email", parameters);
        Assert.assertEquals((Object)expectedAdvanced, (Object)rendered);
    }

    @Test(timeout=30000L)
    public void testLoadUpdatedTemplateFile() throws Exception {
        CountDownLatch loadTemplate = new CountDownLatch(1);
        this.configureTemplateManager(loadTemplate, null);
        String expected = "<html><body>Hello John</body></html>";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Name", "John");
        String rendered = this.templateManager.render("basic-email", parameters);
        Assert.assertEquals((Object)expected, (Object)rendered);
        String updatedTemplate = "<html><body>Hello ${Name}, welcome!</body></html>";
        Files.write(new File(this.templateDir, "basic-email.html").toPath(), updatedTemplate.getBytes(), new OpenOption[0]);
        loadTemplate.await();
        ((IterableAssert)Assertions.assertThat(this.templateManager.getCreatedOrUpdated()).hasSize(1)).contains((Object[])new String[]{"basic-email"});
    }

    @Test(timeout=30000L)
    public void testDeletedTemplateFile() throws Exception {
        CountDownLatch removeTemplate = new CountDownLatch(1);
        this.configureTemplateManager(null, removeTemplate);
        String expected = "<html><body>Hello John</body></html>";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("Name", "John");
        String rendered = this.templateManager.render("basic-email", parameters);
        Assert.assertEquals((Object)expected, (Object)rendered);
        Files.delete(new File(this.templateDir, "basic-email.html").toPath());
        removeTemplate.await();
        ((IterableAssert)Assertions.assertThat(this.templateManager.getRemoved()).hasSize(1)).contains((Object[])new String[]{"basic-email"});
    }

    private class TrackingTemplateManager
    extends TemplateManager {
        private CountDownLatch loadTemplate;
        private CountDownLatch removeTemplate;
        private Set<String> createdOrUpdated = new LinkedHashSet<String>();
        private Set<String> removed = new LinkedHashSet<String>();

        public TrackingTemplateManager(CountDownLatch loadTemplate, CountDownLatch removeTemplate) {
            this.loadTemplate = loadTemplate;
            this.removeTemplate = removeTemplate;
        }

        protected void loadTemplate(File templateFile) {
            super.loadTemplate(templateFile);
            if (this.loadTemplate != null) {
                this.createdOrUpdated.add(this.resolveTemplateId(templateFile));
                this.loadTemplate.countDown();
            }
        }

        protected void removeTemplate(File templateFile) {
            super.removeTemplate(templateFile);
            if (this.removeTemplate != null) {
                this.removed.add(this.resolveTemplateId(templateFile));
                this.removeTemplate.countDown();
            }
        }

        protected Set<String> getCreatedOrUpdated() {
            return this.createdOrUpdated;
        }

        protected Set<String> getRemoved() {
            return this.removed;
        }
    }
}

