/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.util.HashMap;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.workitem.rest.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.DataTransformer;

public class TransformerJSONandXMLTest {
    @Test
    public void testJSONTransformer() {
        String expectedJson = "{\"name\":\"john\",\"age\":34}";
        DataTransformer transformer = DataTransformerRegistry.get().find("http://www.mvel.org/2.0");
        String expressionR = "new com.fasterxml.jackson.databind.ObjectMapper().readValue(json, clazz)";
        String expressionW = "new com.fasterxml.jackson.databind.ObjectMapper().writeValueAsString(employee)";
        Object compiled = transformer.compile(expressionW, new HashMap());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Person person = new Person();
        person.setAge(34);
        person.setName("john");
        parameters.put("employee", person);
        Object result = transformer.transform(compiled, parameters);
        System.out.println(result);
        Assert.assertEquals((Object)expectedJson, (Object)result);
        Object compiledR = transformer.compile(expressionR, new HashMap());
        parameters.clear();
        parameters.put("json", result);
        parameters.put("clazz", Person.class);
        Object resultr = transformer.transform(compiledR, parameters);
        System.out.println(resultr);
        Assert.assertNotNull((Object)resultr);
        Assert.assertTrue((boolean)(resultr instanceof Person));
        Assert.assertEquals((Object)"john", (Object)((Person)resultr).getName());
        Assert.assertEquals((long)34L, (long)((Person)resultr).getAge().intValue());
    }

    @Test
    public void testJAXBTransformer() {
        String expectedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>34</age><name>john</name></person>";
        DataTransformer transformer = DataTransformerRegistry.get().find("http://www.mvel.org/2.0");
        String expressionR = "java.io.StringReader result = new java.io.StringReader(xml);return javax.xml.bind.JAXBContext.newInstance(classes).createUnmarshaller().unmarshal(result);";
        String expressionW = "java.io.StringWriter result = new java.io.StringWriter();javax.xml.bind.JAXBContext.newInstance(classes).createMarshaller().marshal(employee, result);return result.toString();";
        Object compiled = transformer.compile(expressionW, new HashMap());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Person person = new Person();
        person.setAge(34);
        person.setName("john");
        parameters.put("employee", person);
        parameters.put("classes", Person.class);
        Object result = transformer.transform(compiled, parameters);
        System.out.println(result);
        Assert.assertEquals((Object)expectedXml, (Object)result);
        Object compiledR = transformer.compile(expressionR, new HashMap());
        parameters.clear();
        parameters.put("classes", Person.class);
        parameters.put("xml", result);
        Object resultr = transformer.transform(compiledR, parameters);
        System.out.println(resultr);
        Assert.assertNotNull((Object)resultr);
        Assert.assertTrue((boolean)(resultr instanceof Person));
        Assert.assertEquals((Object)"john", (Object)((Person)resultr).getName());
        Assert.assertEquals((long)34L, (long)((Person)resultr).getAge().intValue());
    }
}

