/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.rest.RESTServiceException;
import org.jbpm.process.workitem.rest.RESTWorkItemHandler;
import org.jbpm.process.workitem.rest.SimpleRESTApplication;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

@RunWith(value=Parameterized.class)
public class BasicAuthRestWorkItemHandlerTest {
    private static final String SERVER_URL = "http://localhost:9998/test";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static Server server;
    private final boolean httpClient43;

    @Parameterized.Parameters(name="Http Client 4.3 api = {0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{true}, {false}};
        return Arrays.asList(locking);
    }

    public BasicAuthRestWorkItemHandlerTest(boolean httpClient43) {
        this.httpClient43 = httpClient43;
    }

    @BeforeClass
    public static void initialize() throws Exception {
        SimpleRESTApplication application = new SimpleRESTApplication();
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)delegate.createEndpoint((Application)application, JAXRSServerFactoryBean.class);
        bean.setProvider((Object)new JAXBElementProvider());
        bean.setAddress("http://localhost:9998" + bean.getAddress());
        bean.setProvider((Object)new AuthenticationFilter());
        server = bean.create();
        server.start();
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (server != null) {
            server.stop();
            server.destroy();
        }
    }

    @Before
    public void setClientApiVersion() {
        RESTWorkItemHandler.HTTP_CLIENT_API_43 = this.httpClient43;
    }

    @Test
    public void testGETOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)SERVER_URL);
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithCustomTimeout() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)SERVER_URL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"30000");
        workItem.setParameter("ReadTimeout", (Object)"25000");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithInvalidTimeout() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)SERVER_URL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("ConnectTimeout", (Object)"");
        workItem.setParameter("ReadTimeout", (Object)"");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testGETOperationWithQueryParam() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test?param=test");
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST test", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Post john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"POST");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("Content", (Object)"<person><name>john</name><age>25</age></person>");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPOSTOperationWithPathParamAndNoContent() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/john");
        workItem.setParameter("Method", (Object)"POST");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Created resource with name john", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testPUTOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>25</age><name>Put john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml");
        workItem.setParameter("Method", (Object)"PUT");
        workItem.setParameter("ContentType", (Object)"application/xml");
        workItem.setParameter("Content", (Object)"<person><name>john</name><age>25</age></person>");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test
    public void testDELETEOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>-1</age><name>deleted john</name></person>";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml/john");
        workItem.setParameter("Method", (Object)"DELETE");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)expected, (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedOperation() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/xml/john");
        workItem.setParameter("Method", (Object)"HEAD");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
    }

    @Test
    public void testHandleErrorOnNotSuccessfulResponse() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, PASSWORD);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)"http://localhost:9998/test/notexisting");
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("HandleResponseErrors", (Object)"true");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        try {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should throw exception as it was instructed to do so");
        }
        catch (WorkItemHandlerRuntimeException ex) {
            RESTServiceException e = (RESTServiceException)ex.getCause().getCause();
            Assert.assertEquals((long)405L, (long)e.getStatus());
            Assert.assertEquals((Object)"http://localhost:9998/test/notexisting", (Object)e.getEndoint());
            Assert.assertEquals((Object)"", (Object)e.getResponse());
        }
    }

    @Test
    public void testHandleErrorOnNotSuccessfulResponseWrongCredentials() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler(USERNAME, "wrongpassword");
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)SERVER_URL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("HandleResponseErrors", (Object)"true");
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        try {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should throw exception as it was instructed to do so");
        }
        catch (WorkItemHandlerRuntimeException ex) {
            RESTServiceException e = (RESTServiceException)ex.getCause().getCause();
            Assert.assertEquals((long)401L, (long)e.getStatus());
            Assert.assertEquals((Object)SERVER_URL, (Object)e.getEndoint());
            Assert.assertEquals((Object)"", (Object)e.getResponse());
        }
    }

    @Test
    public void testGETOperationAuthTypeAsParam() {
        RESTWorkItemHandler handler = new RESTWorkItemHandler();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)SERVER_URL);
        workItem.setParameter("Method", (Object)"GET");
        workItem.setParameter("AuthType", (Object)"BASIC");
        workItem.setParameter("Username", (Object)USERNAME);
        workItem.setParameter("Password", (Object)PASSWORD);
        TestWorkItemManager manager = new TestWorkItemManager((WorkItem)workItem);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        String result = (String)workItem.getResult("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
        int responseCode = (Integer)workItem.getResult("Status");
        Assert.assertNotNull((Object)responseCode);
        Assert.assertEquals((long)200L, (long)responseCode);
        String responseMsg = (String)workItem.getResult("StatusMsg");
        Assert.assertNotNull((Object)responseMsg);
        Assert.assertEquals((Object)("request to endpoint " + workItem.getParameter("Url") + " successfully completed OK"), (Object)responseMsg);
    }

    private static class AuthenticationFilter
    implements ContainerRequestFilter {
        private AuthenticationFilter() {
        }

        public void filter(ContainerRequestContext containerRequestContext) throws IOException {
            String password;
            String[] usernamePassword = this.decodeBase64UsernameAndPassword(containerRequestContext.getHeaderString("Authorization"));
            String username = usernamePassword[0];
            if (!this.isAuthenticated(username, password = usernamePassword[1])) {
                containerRequestContext.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)"Basic").build());
            }
        }

        private String[] decodeBase64UsernameAndPassword(String base64authzHeader) {
            String usernamePasswordBase64 = base64authzHeader.substring("Basic ".length());
            String usernamePassword = new String(Base64.getDecoder().decode(usernamePasswordBase64), StandardCharsets.UTF_8);
            return usernamePassword.split(":");
        }

        private boolean isAuthenticated(String username, String password) {
            return BasicAuthRestWorkItemHandlerTest.USERNAME.equals(username) && BasicAuthRestWorkItemHandlerTest.PASSWORD.equals(password);
        }
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private WorkItem workItem;

        TestWorkItemManager(WorkItem workItem) {
            this.workItem = workItem;
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            ((WorkItemImpl)this.workItem).setResults(results);
        }

        public void abortWorkItem(long id) {
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

