/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.rest.RESTWorkItemHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.stop.Stop;
import org.mockserver.stop.Stoppable;
import org.mockserver.verify.VerificationTimes;

public class RESTWorkItemHandlerProxyTest {
    private static ClientAndServer proxy;
    private static ClientAndServer mockServer;
    private static int serverPort;

    @BeforeClass
    public static void startProxy() {
        proxy = ClientAndServer.startClientAndServer((Integer[])new Integer[0]);
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", Integer.toString(proxy.getLocalPort()));
        mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[0]);
        serverPort = mockServer.getLocalPort();
    }

    @AfterClass
    public static void stopProxy() {
        Stop.stopQuietly((Stoppable)mockServer);
        Stop.stopQuietly((Stoppable)proxy);
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
    }

    @Before
    public void startMockServer() {
        mockServer.reset();
        proxy.reset();
    }

    @Test
    public void testGETWithProxyOperation() {
        System.setProperty("org.kie.workitem.rest.useSystemProperties", "true");
        try {
            this.invokeGet();
            proxy.verify(HttpRequest.request().withPath("/test"), VerificationTimes.exactly((int)1));
        }
        finally {
            System.clearProperty("org.kie.workitem.rest.useSystemProperties");
        }
    }

    @Test
    public void testGETWithoutProxyOperation() {
        this.invokeGet();
        proxy.verify(HttpRequest.request().withPath("/test"), VerificationTimes.exactly((int)0));
    }

    @Test
    public void testGETWithProxyOperationLegacy() {
        System.setProperty("org.kie.workitem.rest.useSystemProperties", "true");
        RESTWorkItemHandler.HTTP_CLIENT_API_43 = false;
        try {
            this.invokeGet();
            proxy.verify(HttpRequest.request().withPath("/test"), VerificationTimes.exactly((int)1));
        }
        finally {
            System.clearProperty("org.kie.workitem.rest.useSystemProperties");
            RESTWorkItemHandler.HTTP_CLIENT_API_43 = true;
        }
    }

    @Test
    public void testGETWithoutProxyOperationLegacy() {
        RESTWorkItemHandler.HTTP_CLIENT_API_43 = false;
        try {
            this.invokeGet();
            proxy.verify(HttpRequest.request().withPath("/test"), VerificationTimes.exactly((int)0));
        }
        finally {
            RESTWorkItemHandler.HTTP_CLIENT_API_43 = true;
        }
    }

    private void invokeGet() {
        mockServer.when(HttpRequest.request().withPath("/test")).respond(HttpResponse.response().withHeaders(new Header[]{new Header(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{"plain/test"})}).withBody("Hello from REST"));
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Url", (Object)("http://localhost:" + serverPort + "/test"));
        workItem.setParameter("Method", (Object)"GET");
        TestWorkItemManager manager = new TestWorkItemManager();
        new RESTWorkItemHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Map results = manager.getResults(Long.valueOf(workItem.getId()));
        Assert.assertNotNull((String)"results cannot be null", (Object)results);
        String result = (String)results.get("Result");
        Assert.assertNotNull((String)"result cannot be null", (Object)result);
        Assert.assertEquals((Object)"Hello from REST", (Object)result);
    }
}

