/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.drools.core.util.StringUtils;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.rest.RESTServiceException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="RestDefinitions.wid", name="Rest", displayName="Rest", defaultHandler="mvel: new org.jbpm.process.workitem.rest.RESTWorkItemHandler()", documentation="jbpm-workitems-rest/index.html", category="jbpm-workitems-rest", icon="defaultresticon.png", parameters={@WidParameter(name="Url"), @WidParameter(name="Method"), @WidParameter(name="HandleResponseErrors"), @WidParameter(name="ResultClass"), @WidParameter(name="AcceptHeader"), @WidParameter(name="AcceptCharset"), @WidParameter(name="Headers"), @WidParameter(name="AuthType"), @WidParameter(name="ConnectTimeout"), @WidParameter(name="ReadTimeout"), @WidParameter(name="Content"), @WidParameter(name="ContentData"), @WidParameter(name="Username"), @WidParameter(name="Password"), @WidParameter(name="AuthUrl"), @WidParameter(name="ContentType"), @WidParameter(name="ContentTypeCharset"), @WidParameter(name="Cookie"), @WidParameter(name="CookiePath")}, results={@WidResult(name="Result", runtimeType="java.lang.Object")}, mavenDepends={@WidMavenDepends(group="org.jbpm", artifact="jbpm-workitems-rest", version="7.64.0-SNAPSHOT")}, serviceInfo=@WidService(category="REST", description="Perform REST calls", keywords="rest,call", action=@WidAction(title="Perform a Rest call"), authinfo=@WidAuth(required=true, params={"username", "password"}, paramsdescription={"User Name", "Password"})))
public class RESTWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(RESTWorkItemHandler.class);
    private static final int DEFAULT_TOTAL_POOL_CONNECTIONS = 500;
    private static final int DEFAULT_MAX_POOL_CONNECTIONS_PER_ROUTE = 50;
    protected static final String USE_SYSTEM_PROPERTIES = "org.kie.workitem.rest.useSystemProperties";
    public static final String PARAM_AUTH_TYPE = "AuthType";
    public static final String PARAM_CONNECT_TIMEOUT = "ConnectTimeout";
    public static final String PARAM_READ_TIMEOUT = "ReadTimeout";
    public static final String PARAM_CONTENT_TYPE = "ContentType";
    public static final String PARAM_CONTENT_TYPE_CHARSET = "ContentTypeCharset";
    public static final String PARAM_HEADERS = "Headers";
    public static final String PARAM_CONTENT = "Content";
    public static final String PARAM_CONTENT_DATA = "ContentData";
    public static final String PARAM_USERNAME = "Username";
    public static final String PARAM_PASSWORD = "Password";
    public static final String PARAM_AUTHURL = "AuthUrl";
    public static final String PARAM_RESULT = "Result";
    public static final String PARAM_STATUS = "Status";
    public static final String PARAM_STATUS_MSG = "StatusMsg";
    public static final String PARAM_COOKIE = "Cookie";
    public static final String PARAM_COOKIE_PATH = "CookiePath";
    private String username;
    private String password;
    private AuthenticationType type;
    private String authUrl;
    private boolean doCacheClient;
    private ClassLoader classLoader;
    protected static PoolingHttpClientConnectionManager connectionManager;
    protected static CloseableHttpClient cachedClient;
    protected static boolean HTTP_CLIENT_API_43;

    public RESTWorkItemHandler() {
        this(false);
    }

    public RESTWorkItemHandler(boolean doCacheClient) {
        this(doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.type = AuthenticationType.NONE;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(String username, String password) {
        this(username, password, false);
    }

    public RESTWorkItemHandler(String username, String password, boolean doCacheClient) {
        this(username, password, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(String username, String password, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(String username, String password, String authUrl) {
        this(username, password, authUrl, false);
    }

    public RESTWorkItemHandler(String username, String password, String authUrl, boolean doCacheClient) {
        this(username, password, authUrl, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(String username, String password, String authUrl, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.FORM_BASED;
        this.authUrl = authUrl;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public RESTWorkItemHandler(ClassLoader classLoader, boolean doCacheClient) {
        this(classLoader, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(ClassLoader classLoader, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.type = AuthenticationType.NONE;
        this.classLoader = classLoader;
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader) {
        this(username, password, classLoader, false);
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader, boolean doCacheClient) {
        this(username, password, classLoader, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
        this.classLoader = classLoader;
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(String username, String password, String authUrl, ClassLoader classLoader) {
        this(username, password, authUrl, classLoader, false);
    }

    public RESTWorkItemHandler(String username, String password, String authUrl, ClassLoader classLoader, boolean doCacheClient) {
        this(username, password, authUrl, classLoader, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(String username, String password, String authUrl, ClassLoader classLoader, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.FORM_BASED;
        this.authUrl = authUrl;
        this.classLoader = classLoader;
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
    }

    public RESTWorkItemHandler(String handlingProcessId, String handlingStrategy, String username, String password) {
        this(handlingProcessId, handlingStrategy, username, password, false);
    }

    public RESTWorkItemHandler(String handlingProcessId, String handlingStrategy, String username, String password, boolean doCacheClient) {
        this(handlingProcessId, handlingStrategy, username, password, doCacheClient, 500, 50);
    }

    public RESTWorkItemHandler(String handlingProcessId, String handlingStrategy, String username, String password, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public RESTWorkItemHandler(ClassLoader classLoader, String handlingProcessId, String handlingStrategy) {
        this(classLoader, false, handlingProcessId, handlingStrategy);
    }

    public RESTWorkItemHandler(ClassLoader classLoader, boolean doCacheClient, String handlingProcessId, String handlingStrategy) {
        this(classLoader, doCacheClient, 500, 50, handlingProcessId, handlingStrategy);
    }

    public RESTWorkItemHandler(ClassLoader classLoader, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute, String handlingProcessId, String handlingStrategy) {
        this.logProtocol();
        this.type = AuthenticationType.NONE;
        this.classLoader = classLoader;
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader, String handlingProcessId, String handlingStrategy) {
        this(username, password, classLoader, false, handlingProcessId, handlingStrategy);
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader, boolean doCacheClient, String handlingProcessId, String handlingStrategy) {
        this(username, password, classLoader, doCacheClient, 500, 50, handlingProcessId, handlingStrategy);
    }

    public RESTWorkItemHandler(String username, String password, ClassLoader classLoader, boolean doCacheClient, int totalPoolConnections, int maxPoolConnectionsPerRoute, String handlingProcessId, String handlingStrategy) {
        this.logProtocol();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
        this.classLoader = classLoader;
        this.doCacheClient = doCacheClient;
        if (doCacheClient) {
            connectionManager.setMaxTotal(totalPoolConnections);
            connectionManager.setDefaultMaxPerRoute(maxPoolConnectionsPerRoute);
        }
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    private void logProtocol() {
        logger.debug(HTTP_CLIENT_API_43 ? "REST work item handler will use http client 4.3 api" : "REST work item handler will NOT use http client 4.3 api");
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public boolean getDoCacheClient() {
        return this.doCacheClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Integer readTimeout;
        Integer connectTimeout;
        boolean handleException = false;
        String urlStr = (String)workItem.getParameter("Url");
        String method = (String)workItem.getParameter("Method");
        String handleExceptionStr = (String)workItem.getParameter("HandleResponseErrors");
        String resultClass = (String)workItem.getParameter("ResultClass");
        String acceptHeader = (String)workItem.getParameter("AcceptHeader");
        String acceptCharset = (String)workItem.getParameter("AcceptCharset");
        String headers = (String)workItem.getParameter(PARAM_HEADERS);
        String cookie = (String)workItem.getParameter(PARAM_COOKIE);
        String cookiePath = (String)workItem.getParameter(PARAM_COOKIE_PATH);
        if (urlStr == null) {
            throw new IllegalArgumentException("Url is a required parameter");
        }
        if (method == null || method.trim().length() == 0) {
            method = "GET";
        }
        if (handleExceptionStr != null) {
            handleException = Boolean.parseBoolean(handleExceptionStr);
        }
        Map params = workItem.getParameters();
        AuthenticationType authType = this.type;
        if (params.get(PARAM_AUTH_TYPE) != null) {
            authType = AuthenticationType.valueOf((String)params.get(PARAM_AUTH_TYPE));
        }
        if ((connectTimeout = this.getParamAsInt(params.get(PARAM_CONNECT_TIMEOUT))) == null) {
            connectTimeout = 60000;
        }
        if ((readTimeout = this.getParamAsInt(params.get(PARAM_READ_TIMEOUT))) == null) {
            readTimeout = 60000;
        }
        if (headers == null) {
            headers = "";
        }
        HttpClient httpClient = this.getHttpClient(readTimeout, connectTimeout, urlStr, cookie, cookiePath);
        Object methodObject = this.configureRequest(method, urlStr, params, acceptHeader, acceptCharset, headers);
        try {
            HttpResponse response = this.doRequestWithAuthorization(httpClient, methodObject, (Map<String, Object>)params, authType);
            StatusLine statusLine = response.getStatusLine();
            int responseCode = statusLine.getStatusCode();
            HashMap<String, Object> results = new HashMap<String, Object>();
            HttpEntity respEntity = response.getEntity();
            String responseBody = null;
            String contentType = null;
            if (respEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)respEntity, (String)acceptCharset);
                if (respEntity.getContentType() != null) {
                    contentType = respEntity.getContentType().getValue();
                }
            }
            if (responseCode >= 200 && responseCode < 300) {
                this.postProcessResult(responseBody, resultClass, contentType, results);
                results.put(PARAM_STATUS_MSG, "request to endpoint " + urlStr + " successfully completed " + statusLine.getReasonPhrase());
            } else if (handleException) {
                this.handleException(new RESTServiceException(responseCode, responseBody, urlStr));
            } else {
                logger.warn("Unsuccessful response from REST server (status: {}, endpoint: {}, response: {}", new Object[]{responseCode, urlStr, responseBody});
                results.put(PARAM_STATUS_MSG, "endpoint " + urlStr + " could not be reached: " + responseBody);
            }
            results.put(PARAM_STATUS, responseCode);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                this.close(httpClient, methodObject);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected Integer getParamAsInt(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof String && !((String)param).isEmpty()) {
            return Integer.parseInt((String)param);
        }
        if (param instanceof Number) {
            return ((Number)param).intValue();
        }
        return null;
    }

    protected void setCharset(RequestBuilder builder, String charset) {
        if (charset != null) {
            builder.addHeader("Accept-Charset", charset);
        }
    }

    protected void addAcceptHeader(RequestBuilder builder, String value) {
        if (value != null) {
            builder.addHeader("Accept", value);
        }
    }

    protected void setCharset(HttpRequestBase theMethod, String charset) {
        if (charset != null) {
            theMethod.addHeader("Accept-Charset", charset);
        }
    }

    protected void addAcceptHeader(HttpRequestBase theMethod, String value) {
        if (value != null) {
            theMethod.addHeader("Accept", value);
        }
    }

    protected void addCustomHeaders(String headers, BiConsumer<String, String> consumer) {
        for (String h : headers.split(";")) {
            String[] headerParts = h.split("=", 2);
            if (headerParts.length != 2) continue;
            consumer.accept(headerParts[0], headerParts[1]);
        }
    }

    protected void setBody(RequestBuilder builder, Map<String, Object> params) {
        if (params.containsKey(PARAM_CONTENT_DATA) || params.containsKey(PARAM_CONTENT)) {
            try {
                Object content;
                Object object = content = params.get(PARAM_CONTENT_DATA) != null ? params.get(PARAM_CONTENT_DATA) : params.get(PARAM_CONTENT);
                if (!(content instanceof String)) {
                    content = this.transformRequest(content, this.getContentTypeAndCharset(params));
                }
                StringEntity entity = new StringEntity((String)content, ContentType.parse((String)this.getContentTypeAndCharset(params)));
                builder.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedCharsetException e) {
                throw new RuntimeException("Cannot set body for REST request [" + builder.getMethod() + "] " + builder.getUri(), e);
            }
        }
    }

    protected void setBody(HttpRequestBase theMethod, Map<String, Object> params) {
        if (params.containsKey(PARAM_CONTENT_DATA) || params.containsKey(PARAM_CONTENT)) {
            Object content;
            Object object = content = params.get(PARAM_CONTENT_DATA) != null ? params.get(PARAM_CONTENT_DATA) : params.get(PARAM_CONTENT);
            if (!(content instanceof String)) {
                content = this.transformRequest(content, this.getContentTypeAndCharset(params));
            }
            ((HttpEntityEnclosingRequestBase)theMethod).setEntity((HttpEntity)new StringEntity((String)content, ContentType.parse((String)this.getContentTypeAndCharset(params))));
        }
    }

    protected void postProcessResult(String result, String resultClass, String contentType, Map<String, Object> results) {
        if (!StringUtils.isEmpty((CharSequence)resultClass) && !StringUtils.isEmpty((CharSequence)contentType)) {
            try {
                Class<?> clazz = Class.forName(resultClass, true, this.classLoader);
                Object resultObject = this.transformResult(clazz, contentType, result);
                results.put(PARAM_RESULT, resultObject);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to transform respose to object", e);
            }
        } else {
            results.put(PARAM_RESULT, result);
        }
    }

    protected String transformRequest(Object data, String contentType) {
        try {
            if (contentType.toLowerCase().contains("application/json")) {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writeValueAsString(data);
            }
            if (contentType.toLowerCase().contains("application/xml")) {
                StringWriter stringRep = new StringWriter();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{data.getClass()});
                jaxbContext.createMarshaller().marshal(data, (Writer)stringRep);
                return stringRep.toString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to transform request to object", e);
        }
        throw new IllegalArgumentException("Unable to find transformer for content type '" + contentType + "' to handle data " + data);
    }

    protected Object transformResult(Class<?> clazz, String contentType, String content) throws Exception {
        if (contentType.toLowerCase().contains("application/json")) {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(content, clazz);
        }
        if (contentType.toLowerCase().contains("application/xml")) {
            StringReader result = new StringReader(content);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            return jaxbContext.createUnmarshaller().unmarshal((Reader)result);
        }
        logger.warn("Unable to find transformer for content type '{}' to handle for content '{}'", (Object)contentType, (Object)content);
        return content;
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, Object method, Map<String, Object> params, AuthenticationType authType) {
        if (HTTP_CLIENT_API_43) {
            return this.doRequestWithAuthorization(httpclient, (RequestBuilder)method, params, authType);
        }
        return this.doRequestWithAuthorization(httpclient, (HttpRequestBase)method, params, authType);
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, RequestBuilder requestBuilder, Map<String, Object> params, AuthenticationType type) {
        if (type == null || type == AuthenticationType.NONE) {
            HttpUriRequest request = requestBuilder.build();
            try {
                return httpclient.execute(request);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        String u = (String)params.get(PARAM_USERNAME);
        String p = (String)params.get(PARAM_PASSWORD);
        if (u == null || p == null) {
            u = this.username;
            p = this.password;
        }
        if (u == null) {
            throw new IllegalArgumentException("Could not find username");
        }
        if (p == null) {
            throw new IllegalArgumentException("Could not find password");
        }
        if (type == AuthenticationType.BASIC) {
            URI requestUri = requestBuilder.getUri();
            HttpHost targetHost = new HttpHost(requestUri.getHost(), requestUri.getPort(), requestUri.getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext clientContext = HttpClientContext.create();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(requestUri.getHost(), requestUri.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(u, p));
            clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            clientContext.setAuthCache((AuthCache)authCache);
            HttpUriRequest request = requestBuilder.build();
            try {
                return httpclient.execute(targetHost, (HttpRequest)request, (HttpContext)clientContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request with preemptive authentication [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        if (type == AuthenticationType.FORM_BASED) {
            UrlEncodedFormEntity formEntity;
            String authUrlStr;
            HttpUriRequest request = requestBuilder.build();
            int statusCode = -1;
            try {
                HttpResponse initialResponse = httpclient.execute(request);
                statusCode = initialResponse.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not execute request for form-based authentication", e);
            }
            finally {
                request.abort();
            }
            if (statusCode != 401) {
                logger.error("Expected form authentication request with status {} but status on response is {}: proceeding anyways", (Object)401, (Object)statusCode);
            }
            if ((authUrlStr = (String)params.get(PARAM_AUTHURL)) == null) {
                authUrlStr = this.authUrl;
            }
            if (authUrlStr == null) {
                throw new IllegalArgumentException("Could not find authentication url");
            }
            HttpPost authMethod = new HttpPost(authUrlStr);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>(2);
            formParams.add(new BasicNameValuePair("j_username", u));
            formParams.add(new BasicNameValuePair("j_password", p));
            try {
                formEntity = new UrlEncodedFormEntity(formParams);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Could not encode authentication parameters into request body", uee);
            }
            authMethod.setEntity((HttpEntity)formEntity);
            try {
                httpclient.execute((HttpUriRequest)authMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            finally {
                authMethod.releaseConnection();
            }
            request = requestBuilder.build();
            try {
                return httpclient.execute(request);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        throw new RuntimeException("Unknown AuthenticationType " + (Object)((Object)type));
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, HttpRequestBase httpMethod, Map<String, Object> params, AuthenticationType type) {
        if (type == null || type == AuthenticationType.NONE) {
            try {
                return httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        String u = (String)params.get(PARAM_USERNAME);
        String p = (String)params.get(PARAM_PASSWORD);
        if (u == null || p == null) {
            u = this.username;
            p = this.password;
        }
        if (u == null) {
            throw new IllegalArgumentException("Could not find username");
        }
        if (p == null) {
            throw new IllegalArgumentException("Could not find password");
        }
        if (type == AuthenticationType.BASIC) {
            HttpHost targetHost = new HttpHost(httpMethod.getURI().getHost(), httpMethod.getURI().getPort(), httpMethod.getURI().getScheme());
            ((DefaultHttpClient)httpclient).getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(u, p));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            try {
                return httpclient.execute(targetHost, (HttpRequest)httpMethod, (HttpContext)localcontext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        if (type == AuthenticationType.FORM_BASED) {
            String authUrlStr = (String)params.get(PARAM_AUTHURL);
            if (authUrlStr == null) {
                authUrlStr = this.authUrl;
            }
            if (authUrlStr == null) {
                throw new IllegalArgumentException("Could not find authentication url");
            }
            try {
                httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not execute request for form-based authentication", e);
            }
            finally {
                httpMethod.releaseConnection();
            }
            HttpPost authMethod = new HttpPost(authUrlStr);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("j_username", u));
            nvps.add(new BasicNameValuePair("j_password", p));
            authMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, Consts.UTF_8));
            try {
                httpclient.execute((HttpUriRequest)authMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            finally {
                authMethod.releaseConnection();
            }
            try {
                return httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        throw new RuntimeException("Unknown AuthenticationType " + (Object)((Object)type));
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected HttpClient getHttpClient(Integer readTimeout, Integer connectTimeout, String url, String cookie, String cookiePath) {
        HttpRoutePlanner routePlanner;
        BasicCookieStore basicCookieStore;
        if (this.getDoCacheClient() && HTTP_CLIENT_API_43) {
            if (cachedClient == null) {
                cachedClient = this.getNewPooledHttpClient(readTimeout, connectTimeout);
            }
            return cachedClient;
        }
        if (HTTP_CLIENT_API_43) {
            BasicCookieStore basicCookieStore2;
            RequestConfig config = RequestConfig.custom().setSocketTimeout(readTimeout.intValue()).setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).build();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config);
            if (cookie != null && !cookie.isEmpty() && (basicCookieStore2 = this.addCookie(url, cookie, cookiePath)) != null) {
                clientBuilder.setDefaultCookieStore((CookieStore)basicCookieStore2);
            }
            if (Boolean.getBoolean(USE_SYSTEM_PROPERTIES)) {
                HttpRoutePlanner routePlanner2 = this.getRoutePlanner();
                if (routePlanner2 != null) {
                    clientBuilder.setRoutePlanner(routePlanner2);
                }
                clientBuilder.useSystemProperties();
            }
            return clientBuilder.build();
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setIntParameter("http.socket.timeout", readTimeout.intValue());
        httpClient.getParams().setIntParameter("http.connection.timeout", connectTimeout.intValue());
        if (cookie != null && !cookie.isEmpty() && (basicCookieStore = this.addCookie(url, cookie, cookiePath)) != null) {
            httpClient.setCookieStore((CookieStore)basicCookieStore);
        }
        if (Boolean.getBoolean(USE_SYSTEM_PROPERTIES) && (routePlanner = this.getRoutePlanner()) != null) {
            httpClient.setRoutePlanner(routePlanner);
        }
        return httpClient;
    }

    protected BasicCookieStore addCookie(String url, String cookie, String cookiePath) {
        String host = null;
        BasicClientCookie basicClientCookie = null;
        BasicCookieStore basicCookieStore = null;
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            host = null;
            logger.error("Unexpected exception occured while retriving host", (Throwable)e);
            return null;
        }
        basicCookieStore = new BasicCookieStore();
        for (String c : cookie.split(";")) {
            String[] cookieParts = c.split("=", 2);
            if (cookieParts.length != 2 || !this.validateCookie(cookieParts)) continue;
            basicClientCookie = new BasicClientCookie(cookieParts[0], cookieParts[1]);
            basicClientCookie.setDomain(host);
            if (cookiePath != null && !cookiePath.isEmpty()) {
                basicClientCookie.setPath(cookiePath);
            } else {
                basicClientCookie.setPath("/");
            }
            basicCookieStore.addCookie((Cookie)basicClientCookie);
        }
        return basicCookieStore;
    }

    private boolean validateCookie(String[] cookieParts) {
        if (!cookieParts[0].trim().isEmpty() && !cookieParts[1].trim().isEmpty()) {
            return true;
        }
        logger.error("Provided cookie " + Arrays.toString(cookieParts) + " is not valid.");
        return false;
    }

    private HttpRoutePlanner getRoutePlanner() {
        String proxyHost = System.getProperty("http.proxyHost");
        Integer proxyPort = Integer.getInteger("http.proxyPort");
        return proxyHost != null && proxyPort != null ? new DefaultProxyRoutePlanner(new HttpHost(proxyHost, proxyPort.intValue())) : null;
    }

    protected CloseableHttpClient getNewPooledHttpClient(Integer readTimeout, Integer connectTimeout) {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(readTimeout.intValue()).setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
    }

    protected void close(HttpClient httpClient, Object httpMethod) throws IOException {
        if (HTTP_CLIENT_API_43) {
            if (cachedClient == null) {
                ((CloseableHttpClient)httpClient).close();
            }
        } else {
            ((HttpRequestBase)httpMethod).releaseConnection();
        }
    }

    protected Object configureRequest(String method, String urlStr, Map<String, Object> params, String acceptHeaderValue, String acceptCharset, String httpHeaders) {
        if (HTTP_CLIENT_API_43) {
            RequestBuilder builder = null;
            if ("GET".equals(method)) {
                builder = RequestBuilder.get().setUri(urlStr);
                this.addAcceptHeader(builder, acceptHeaderValue);
                this.setCharset(builder, acceptCharset);
            } else if ("POST".equals(method)) {
                builder = RequestBuilder.post().setUri(urlStr);
                this.setBody(builder, params);
                this.addAcceptHeader(builder, acceptHeaderValue);
            } else if ("PUT".equals(method)) {
                builder = RequestBuilder.put().setUri(urlStr);
                this.setBody(builder, params);
                this.addAcceptHeader(builder, acceptHeaderValue);
            } else if ("DELETE".equals(method)) {
                builder = RequestBuilder.delete().setUri(urlStr);
            } else if ("PATCH".equals(method)) {
                builder = RequestBuilder.patch().setUri(urlStr);
                this.setBody(builder, params);
                this.addAcceptHeader(builder, acceptHeaderValue);
            } else {
                throw new IllegalArgumentException("Method " + method + " is not supported");
            }
            this.addCustomHeaders(httpHeaders, (arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
            return builder;
        }
        HttpGet theMethod = null;
        if ("GET".equals(method)) {
            theMethod = new HttpGet(urlStr);
            this.addAcceptHeader((HttpRequestBase)theMethod, acceptHeaderValue);
            this.setCharset((HttpRequestBase)theMethod, acceptCharset);
        } else if ("POST".equals(method)) {
            theMethod = new HttpPost(urlStr);
            this.setBody((HttpRequestBase)theMethod, params);
            this.addAcceptHeader((HttpRequestBase)theMethod, acceptHeaderValue);
        } else if ("PUT".equals(method)) {
            theMethod = new HttpPut(urlStr);
            this.setBody((HttpRequestBase)theMethod, params);
            this.addAcceptHeader((HttpRequestBase)theMethod, acceptHeaderValue);
        } else if ("DELETE".equals(method)) {
            theMethod = new HttpDelete(urlStr);
        } else if ("PATCH".equals(method)) {
            theMethod = new HttpPatch(urlStr);
            this.setBody((HttpRequestBase)theMethod, params);
            this.addAcceptHeader((HttpRequestBase)theMethod, acceptHeaderValue);
        } else {
            throw new IllegalArgumentException("Method " + method + " is not supported");
        }
        this.addCustomHeaders(httpHeaders, (arg_0, arg_1) -> ((HttpRequestBase)theMethod).addHeader(arg_0, arg_1));
        return theMethod;
    }

    protected String getContentTypeAndCharset(Map<String, Object> params) {
        String contentType = (String)params.get(PARAM_CONTENT_TYPE);
        String contentTypeCharset = (String)params.get(PARAM_CONTENT_TYPE_CHARSET);
        if (contentType == null || contentTypeCharset == null) {
            return contentType;
        }
        if (!contentType.contains("charset=")) {
            return contentType + ";charset=" + contentTypeCharset;
        }
        return contentType;
    }

    public void close() {
        try {
            if (cachedClient != null) {
                cachedClient.close();
            }
        }
        catch (Exception e) {
            logger.error("Unable to close cached client connection: " + e.getMessage());
        }
    }

    static {
        HTTP_CLIENT_API_43 = true;
        try {
            Class.forName("org.apache.http.client.methods.RequestBuilder");
            HTTP_CLIENT_API_43 = true;
        }
        catch (ClassNotFoundException e) {
            HTTP_CLIENT_API_43 = false;
        }
        connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(500);
        connectionManager.setDefaultMaxPerRoute(50);
    }

    public static enum AuthenticationType {
        NONE,
        BASIC,
        FORM_BASED;

    }
}

