/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jabber;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.process.instance.WorkItemHandler;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemManager;

public class JabberWorkItemHandler
implements WorkItemHandler {
    private String user;
    private String password;
    private String server;
    private int port;
    private String service;
    private String text;
    private List<String> toUsers = new ArrayList<String>();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        this.user = (String)workItem.getParameter("User");
        this.password = (String)workItem.getParameter("Password");
        this.server = (String)workItem.getParameter("Server");
        String portString = (String)workItem.getParameter("Port");
        if (portString != null && !portString.equals("")) {
            this.port = Integer.valueOf((String)workItem.getParameter("Port"));
        }
        this.service = (String)workItem.getParameter("Service");
        this.text = (String)workItem.getParameter("Text");
        String to = (String)workItem.getParameter("To");
        if (to == null || to.trim().length() == 0) {
            throw new RuntimeException("IM must have one or more to adresses");
        }
        for (String s : to.split(";")) {
            if (s == null || "".equals(s)) continue;
            this.toUsers.add(s);
        }
        ConnectionConfiguration conf = new ConnectionConfiguration(this.server, this.port, this.service);
        XMPPConnection connection = null;
        try {
            connection = this.server != null && !this.server.equals("") && this.port != 0 ? new XMPPConnection(conf) : new XMPPConnection(this.service);
            connection.connect();
            System.out.println("Connected to " + connection.getHost());
        }
        catch (XMPPException ex) {
            Logger.getLogger(JabberWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Failed to connect to " + connection.getHost());
            System.exit(1);
        }
        try {
            connection.login(this.user, this.password);
            System.out.println("Logged in as " + connection.getUser());
            Presence presence = new Presence(Presence.Type.available);
            connection.sendPacket((Packet)presence);
        }
        catch (XMPPException ex) {
            Logger.getLogger(JabberWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("Failed to log in as " + connection.getUser());
            System.exit(1);
        }
        for (String toUser : this.toUsers) {
            ChatManager chatmanager = connection.getChatManager();
            Chat chat = chatmanager.createChat(toUser, null);
            try {
                Message msg = new Message(toUser, Message.Type.chat);
                msg.setBody(this.text);
                chat.sendMessage(msg);
                System.out.println("Message Sended");
            }
            catch (XMPPException e) {
                System.out.println("Failed to send message");
            }
        }
        connection.disconnect();
        manager.completeWorkItem(workItem.getId(), null);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

