/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.drools.core.process.instance.WorkItemHandler;
import org.jbpm.process.workitem.rest.ResultGeoCodeApi;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RestGeoCodeApiCallWorkItemHandler
implements WorkItemHandler {
    private List<ResultGeoCodeApi> results;
    private int httpResponseCode;

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            String URL2 = (String)workItem.getParameter("URL");
            workItem.getParameters().remove("URL");
            URL2 = URL2 + (String)workItem.getParameter("Service");
            workItem.getParameters().remove("Service");
            URL2 = URL2 + (String)workItem.getParameter("Method");
            workItem.getParameters().remove("Method");
            Set keys = workItem.getParameters().keySet();
            for (String parameter : keys) {
                URL2 = URL2 + parameter + "=" + workItem.getParameter(parameter) + "&";
            }
            URL getUrl = new URL(URL2);
            HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
            connection.setRequestMethod("GET");
            System.out.println("Content-Type: " + connection.getContentType());
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = reader.readLine();
            String response = "";
            while ((line = reader.readLine()) != null) {
                response = response + line;
            }
            this.setHttpResponseCode(connection.getResponseCode());
            this.results = this.parseResults(response);
            System.out.println("" + response);
            connection.disconnect();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(RestGeoCodeApiCallWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RestGeoCodeApiCallWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List<ResultGeoCodeApi> parseResults(String xml) {
        ArrayList<ResultGeoCodeApi> results = new ArrayList<ResultGeoCodeApi>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            doc.getDocumentElement().normalize();
            NodeList listOfResults = doc.getElementsByTagName("Result");
            for (int i = 0; i < listOfResults.getLength(); ++i) {
                ResultGeoCodeApi result = new ResultGeoCodeApi();
                Node nodeResult = listOfResults.item(i);
                if (nodeResult.getNodeType() != 1) continue;
                Element elementResult = (Element)nodeResult;
                result.setPrecision(elementResult.getAttribute("precision"));
                NodeList latitudes = elementResult.getElementsByTagName("Latitude");
                Element latitudeElement = (Element)latitudes.item(0);
                NodeList latitudeNodes = latitudeElement.getChildNodes();
                result.setLatitude(latitudeNodes.item(0).getNodeValue().trim());
                NodeList longitudes = elementResult.getElementsByTagName("Longitude");
                Element longitudeElement = (Element)longitudes.item(0);
                NodeList longitudeNodes = longitudeElement.getChildNodes();
                result.setLongitude(longitudeNodes.item(0).getNodeValue().trim());
                NodeList addresses = elementResult.getElementsByTagName("Address");
                Element addressElement = (Element)addresses.item(0);
                NodeList addressNodes = addressElement.getChildNodes();
                result.setAddress(addressNodes.item(0).getNodeValue().trim());
                NodeList cities = elementResult.getElementsByTagName("City");
                Element cityElement = (Element)cities.item(0);
                NodeList cityNodes = cityElement.getChildNodes();
                result.setCity(cityNodes.item(0).getNodeValue().trim());
                NodeList states = elementResult.getElementsByTagName("State");
                Element stateElement = (Element)states.item(0);
                NodeList stateNodes = stateElement.getChildNodes();
                result.setState(stateNodes.item(0).getNodeValue().trim());
                NodeList zips = elementResult.getElementsByTagName("Zip");
                Element zipElement = (Element)zips.item(0);
                NodeList zipNodes = zipElement.getChildNodes();
                result.setZip(zipNodes.item(0).getNodeValue().trim());
                NodeList countries = elementResult.getElementsByTagName("Country");
                Element countryElement = (Element)countries.item(0);
                NodeList countryNodes = countryElement.getChildNodes();
                result.setCountry(countryNodes.item(0).getNodeValue().trim());
                results.add(result);
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(RestGeoCodeApiCallWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RestGeoCodeApiCallWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(RestGeoCodeApiCallWorkItemHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return results;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public List<ResultGeoCodeApi> getResults() {
        return this.results;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public void setHttpResponseCode(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }
}

