/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.core.Bpmn2Import;
import org.jbpm.process.workitem.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public static final String WSDL_IMPORT_TYPE = "http://schemas.xmlsoap.org/wsdl/";
    private static Logger logger = LoggerFactory.getLogger(WebServiceWorkItemHandler.class);
    private ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
    private KieSession ksession;
    private int asyncTimeout = 10;
    private ClassLoader classLoader;

    public WebServiceWorkItemHandler(KieSession ksession) {
        this.ksession = ksession;
        this.classLoader = this.getClass().getClassLoader();
    }

    public WebServiceWorkItemHandler(KieSession ksession, ClassLoader classloader) {
        this.ksession = ksession;
        this.classLoader = classloader;
    }

    public WebServiceWorkItemHandler(KieSession ksession, int timeout) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
        this.classLoader = this.getClass().getClassLoader();
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String interfaceRef = (String)workItem.getParameter("Interface");
        String operationRef = (String)workItem.getParameter("Operation");
        Object parameter = workItem.getParameter("Parameter");
        String modeParam = (String)workItem.getParameter("Mode");
        WSMode mode = WSMode.valueOf(modeParam == null ? "SYNC" : modeParam.toUpperCase());
        try {
            Client client = this.getWSClient(workItem, interfaceRef);
            switch (mode) {
                case SYNC: {
                    Object[] result = client.invoke(operationRef, new Object[]{parameter});
                    HashMap<String, Object> output = new HashMap<String, Object>();
                    if (result == null || result.length == 0) {
                        output.put("Result", null);
                    } else {
                        output.put("Result", result[0]);
                    }
                    logger.debug("Received sync response {} completeing work item {}", (Object)result, (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), output);
                    break;
                }
                case ASYNC: {
                    final ClientCallback callback = new ClientCallback();
                    final long workItemId = workItem.getId();
                    client.invoke(callback, operationRef, new Object[]{parameter});
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object[] result = callback.get((long)WebServiceWorkItemHandler.this.asyncTimeout, TimeUnit.SECONDS);
                                HashMap<String, Object> output = new HashMap<String, Object>();
                                if (callback.isDone()) {
                                    if (result == null) {
                                        output.put("Result", null);
                                    } else {
                                        output.put("Result", result[0]);
                                    }
                                }
                                logger.debug("Received async response {} completeing work item {}", (Object)result, (Object)workItemId);
                                WebServiceWorkItemHandler.this.ksession.getWorkItemManager().completeWorkItem(workItemId, output);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new RuntimeException("Error encountered while invoking ws operation asynchronously", e);
                            }
                        }
                    }).start();
                    break;
                }
                case ONEWAY: {
                    ClientCallback callbackFF = new ClientCallback();
                    client.invoke(callbackFF, operationRef, new Object[]{parameter});
                    logger.debug("One way operation, not going to wait for response, completing work item {}", (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), new HashMap());
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (this.clients.containsKey(interfaceRef)) {
            return this.clients.get(interfaceRef);
        }
        String importLocation = (String)workItem.getParameter("Url");
        String importNamespace = (String)workItem.getParameter("Namespace");
        if (importLocation != null && importLocation.trim().length() > 0 && importNamespace != null && importNamespace.trim().length() > 0) {
            Client client = this.dcf.createClient(importLocation, new QName(importNamespace, interfaceRef), this.classLoader, null);
            this.clients.put(interfaceRef, client);
            return client;
        }
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        WorkflowProcessImpl process = (WorkflowProcessImpl)this.ksession.getProcessInstance(processInstanceId).getProcess();
        List typedImports = (List)process.getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            Client client = null;
            for (Bpmn2Import importObj : typedImports) {
                if (!WSDL_IMPORT_TYPE.equalsIgnoreCase(importObj.getType())) continue;
                client = this.dcf.createClient(importObj.getLocation(), new QName(importObj.getNamespace(), interfaceRef), this.classLoader, null);
                this.clients.put(interfaceRef, client);
                return client;
            }
        }
        return null;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static enum WSMode {
        SYNC,
        ASYNC,
        ONEWAY;

    }
}

