/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jbpm.process.workitem.AbstractLogOrThrowWorkItemHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(RESTWorkItemHandler.class);
    private String username;
    private String password;
    private AuthenticationType type;
    private String authUrl;

    public RESTWorkItemHandler() {
    }

    public RESTWorkItemHandler(String username, String password) {
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
    }

    public RESTWorkItemHandler(String username, String password, String authUrl) {
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.FORM_BASED;
        this.authUrl = authUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Integer readTimeout;
        Map params;
        Integer connectTimeout;
        String urlStr = (String)workItem.getParameter("Url");
        String method = (String)workItem.getParameter("Method");
        if (urlStr == null) {
            throw new IllegalArgumentException("Url is a required parameter");
        }
        if (method == null || method.trim().length() == 0) {
            method = "GET";
        }
        if ((connectTimeout = this.getParamAsInt((params = workItem.getParameters()).get("ConnectTimeout"))) == null) {
            connectTimeout = 60000;
        }
        if ((readTimeout = this.getParamAsInt(params.get("ReadTimeout"))) == null) {
            readTimeout = 60000;
        }
        HttpClient httpclient = new HttpClient();
        httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeout.intValue());
        httpclient.getHttpConnectionManager().getParams().setSoTimeout(readTimeout.intValue());
        GetMethod theMethod = null;
        if ("GET".equals(method)) {
            theMethod = new GetMethod(urlStr);
        } else if ("POST".equals(method)) {
            theMethod = new PostMethod(urlStr);
            this.setBody((HttpMethod)theMethod, params);
        } else if ("PUT".equals(method)) {
            theMethod = new PutMethod(urlStr);
            this.setBody((HttpMethod)theMethod, params);
        } else if ("DELETE".equals(method)) {
            theMethod = new DeleteMethod(urlStr);
        } else {
            throw new IllegalArgumentException("Method " + method + " is not supported");
        }
        this.doAuthorization(httpclient, (HttpMethod)theMethod, params);
        try {
            int responseCode = httpclient.executeMethod((HttpMethod)theMethod);
            HashMap<String, Object> results = new HashMap<String, Object>();
            if (responseCode >= 200 && responseCode < 300) {
                theMethod.getResponseBody();
                this.postProcessResult(theMethod.getResponseBodyAsString(), results);
                results.put("StatusMsg", "request to endpoint " + urlStr + " successfully completed " + theMethod.getStatusText());
            } else {
                logger.warn("Unsuccessful response from REST server (status {}, endpoint {}, response {}", new Object[]{responseCode, urlStr, theMethod.getResponseBodyAsString()});
                results.put("StatusMsg", "endpoint " + urlStr + " could not be reached: " + theMethod.getResponseBodyAsString());
            }
            results.put("Status", responseCode);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            theMethod.releaseConnection();
        }
    }

    protected Integer getParamAsInt(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof String && !((String)param).isEmpty()) {
            return Integer.parseInt((String)param);
        }
        if (param instanceof Number) {
            return ((Number)param).intValue();
        }
        return null;
    }

    protected void setBody(HttpMethod theMethod, Map<String, Object> params) {
        if (params.containsKey("Content")) {
            try {
                ((EntityEnclosingMethod)theMethod).setRequestEntity((RequestEntity)new StringRequestEntity((String)params.get("Content"), (String)params.get("ContentType"), null));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Cannot set body for REST request " + theMethod, e);
            }
        }
    }

    protected void postProcessResult(String result, Map<String, Object> results) {
        results.put("Result", result);
    }

    protected void doAuthorization(HttpClient httpclient, HttpMethod method, Map<String, Object> params) {
        if (this.type == null) {
            return;
        }
        String u = (String)params.get("Username");
        String p = (String)params.get("Password");
        if (u == null || p == null) {
            u = this.username;
            p = this.password;
        }
        if (u == null) {
            throw new IllegalArgumentException("Could not find username");
        }
        if (p == null) {
            throw new IllegalArgumentException("Could not find password");
        }
        if (this.type == AuthenticationType.BASIC) {
            httpclient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(u, p));
            method.setDoAuthentication(true);
        } else {
            if (this.type == AuthenticationType.FORM_BASED) {
                String authUrlStr = (String)params.get("AuthUrl");
                if (authUrlStr == null) {
                    authUrlStr = this.authUrl;
                }
                if (authUrlStr == null) {
                    throw new IllegalArgumentException("Could not find authentication url");
                }
                try {
                    httpclient.executeMethod(method);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not execute request for form-based authentication", e);
                }
                finally {
                    method.releaseConnection();
                }
                PostMethod authMethod = new PostMethod(authUrlStr);
                NameValuePair[] data = new NameValuePair[]{new NameValuePair("j_username", u), new NameValuePair("j_password", p)};
                authMethod.setRequestBody(data);
                try {
                    httpclient.executeMethod((HttpMethod)authMethod);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not initialize form-based authentication", e);
                }
                finally {
                    authMethod.releaseConnection();
                }
            }
            throw new RuntimeException("Unknown AuthenticationType " + (Object)((Object)this.type));
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public static enum AuthenticationType {
        BASIC,
        FORM_BASED;

    }
}

