/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSignalReceiver
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JMSSignalReceiver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message message) {
        if (!(message instanceof BytesMessage)) return;
        BytesMessage bytesMessage = (BytesMessage)message;
        RuntimeManager runtimeManager = null;
        RuntimeEngine engine = null;
        try {
            String deploymentId = (String)bytesMessage.getObjectProperty("KIE_SignalDeploymentId");
            if (deploymentId == null) {
                deploymentId = (String)bytesMessage.getObjectProperty("KIE_DeploymentId");
            }
            String signal = (String)bytesMessage.getObjectProperty("KIE_Signal");
            Long processInstanceId = (Long)bytesMessage.getObjectProperty("KIE_SignalProcessInstanceId");
            Long workItemId = (Long)bytesMessage.getObjectProperty("KIE_SignalWorkItemId");
            logger.debug("Deployment id '{}', signal '{}', processInstanceId '{}', workItemId '{}'", new Object[]{deploymentId, signal, processInstanceId, workItemId});
            runtimeManager = RuntimeManagerRegistry.get().getManager(deploymentId);
            if (runtimeManager == null) {
                throw new IllegalStateException("There is no runtime manager for deployment " + deploymentId);
            }
            logger.debug("RuntimeManager found for deployment id {}, reading message content with custom class loader of the deployment", (Object)deploymentId);
            Object data = this.readData(bytesMessage, ((InternalRuntimeManager)runtimeManager).getEnvironment().getClassLoader());
            logger.debug("Data read successfully with output {}", data);
            engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
            if (workItemId != null) {
                HashMap<String, Object> results = new HashMap<String, Object>();
                if (data != null) {
                    if (data instanceof Map) {
                        results.putAll((Map)data);
                    } else {
                        results.put("Data", data);
                    }
                }
                logger.debug("About to complete work item with id {} and data {}", (Object)workItemId, results);
                engine.getKieSession().getWorkItemManager().completeWorkItem(workItemId.longValue(), results);
                logger.debug("Successfully completed work item with id {}", (Object)workItemId);
            } else if (signal != null) {
                if (processInstanceId != null) {
                    logger.debug("About to signal process instance with id {} and event data {} with signal {}", new Object[]{processInstanceId, data, signal});
                    engine.getKieSession().signalEvent(signal, data, processInstanceId.longValue());
                } else {
                    logger.debug("About to broadcast signal {} and event data {}", (Object)signal, data);
                    runtimeManager.signalEvent(signal, data);
                }
                logger.debug("Signal completed successfully for signal {} with data {}", (Object)signal, data);
            } else {
                logger.warn("No signal or workitem id is given, skipping this message");
            }
            if (runtimeManager == null || engine == null) return;
        }
        catch (Exception e) {
            logger.error("Unexpected exception while processing signal JMS message: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            if (runtimeManager != null && engine != null) {
                runtimeManager.disposeRuntimeEngine(engine);
            }
        }
        runtimeManager.disposeRuntimeEngine(engine);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readData(BytesMessage message, ClassLoader cl) throws JMSException, Exception {
        Object data = null;
        if (message.getBodyLength() > 0L) {
            byte[] reqData = new byte[(int)message.getBodyLength()];
            message.readBytes(reqData);
            if (reqData != null) {
                ObjectInputStream in = null;
                try {
                    in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                    data = in.readObject();
                }
                catch (IOException e) {
                    logger.warn("Exception while serializing context data", (Throwable)e);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        return data;
    }
}

