/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BPMN2ProcessProvider;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ProcessBuilderFactoryService;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactoryServiceImpl;
import org.drools.core.marshalling.impl.ProcessMarshallerFactory;
import org.drools.core.marshalling.impl.ProcessMarshallerFactoryService;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.bpmn2.BPMN2ProcessProviderImpl;
import org.jbpm.marshalling.impl.ProcessMarshallerFactoryServiceImpl;
import org.jbpm.process.builder.ProcessBuilderFactoryServiceImpl;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.workitem.bpmn2.BusinessRuleTaskHandler;
import org.jbpm.process.workitem.bpmn2.objects.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.KnowledgeBaseFactoryService;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.scanner.MavenRepository;

public class BusinessRuleTaskTest {
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "test-kjar";
    private static final String VERSION = "1.0-SNAPSHOT";
    private KieServices ks = KieServices.Factory.get();

    @Before
    public void setup() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("businessRule.drl"), this.ks.getResources().newClassPathResource("0020-vacation-days.dmn"));
    }

    @Test
    public void testBusinessRuleTaskProcess() throws Exception {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory((KnowledgeBaseFactoryService)new KnowledgeBaseFactoryServiceImpl());
        KieBase kbase = BusinessRuleTaskTest.readKnowledgeBase();
        KieSession ksession = BusinessRuleTaskTest.createSession(kbase);
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION);
        ksession.getWorkItemManager().registerWorkItemHandler("BusinessRuleTask", (WorkItemHandler)handler);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("john"));
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("evaluation.ruletask", params);
        Person variable = (Person)processInstance.getVariable("person");
        Assert.assertEquals((Object)"john", (Object)variable.getName());
        Assert.assertEquals((long)35L, (long)variable.getAge().intValue());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testDecisionTaskProcess() throws Exception {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory((KnowledgeBaseFactoryService)new KnowledgeBaseFactoryServiceImpl());
        KieBase kbase = BusinessRuleTaskTest.readKnowledgeBase();
        KieSession ksession = BusinessRuleTaskTest.createSession(kbase);
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION);
        ksession.getWorkItemManager().registerWorkItemHandler("DecisionTask", (WorkItemHandler)handler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        params.put("yearsOfService", 1);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("BPMN2-BusinessRuleTask", params);
        BigDecimal variable = (BigDecimal)processInstance.getVariable("vacationDays");
        Assert.assertEquals((long)27L, (long)variable.intValue());
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    private static KieBase readKnowledgeBase() throws Exception {
        ProcessBuilderFactory.setProcessBuilderFactoryService((ProcessBuilderFactoryService)new ProcessBuilderFactoryServiceImpl());
        ProcessMarshallerFactory.setProcessMarshallerFactoryService((ProcessMarshallerFactoryService)new ProcessMarshallerFactoryServiceImpl());
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)new BPMN2ProcessProviderImpl());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"businessRuleTaskProcess.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"businessRuleTaskDMN.bpmn2"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static KieSession createSession(KieBase kbase) {
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        return kbase.newKieSession(config, EnvironmentFactory.newEnvironment());
    }

    private byte[] createAndDeployJar(KieServices ks, ReleaseId releaseId, Resource ... resources) throws Exception {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        ((InternalKieBuilder)kieBuilder).buildAll(o -> true);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] pomXmlContent = IOUtils.toByteArray((InputStream)kieModule.getPomAsStream());
        File pom = new File("target", UUID.randomUUID().toString());
        Files.write(pom.toPath(), pomXmlContent, new OpenOption[0]);
        MavenRepository.getMavenRepository().installArtifact(releaseId, kieModule, pom);
        byte[] jar = kieModule.getBytes();
        return jar;
    }
}

