/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private JbpmConfiguration jbpmConfiguration;
    private static final Log log = LogFactory.getLog((Class)(class$org$jbpm$web$ProcessUploadServlet == null ? (class$org$jbpm$web$ProcessUploadServlet = ProcessUploadServlet.class$((String)"org.jbpm.web.ProcessUploadServlet")) : class$org$jbpm$web$ProcessUploadServlet));
    static /* synthetic */ Class class$org$jbpm$web$ProcessUploadServlet;

    public void init() throws ServletException {
        String jbpmCfgResource = this.getServletContext().getInitParameter("jbpm.configuration.resource");
        this.jbpmConfiguration = JbpmConfiguration.getInstance((String)jbpmCfgResource);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"handling status request");
        }
        PrintWriter out = response.getWriter();
        this.writeHeader(out);
        out.println("<p>GPD deployer is operational</p>");
        this.writeTrailer(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"handling upload request");
        }
        try {
            InputStream processStream = this.parseRequest(request, response);
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            try {
                ProcessDefinition processDefinition = this.parseProcessArchive(processStream);
                this.deployProcessDefinition(processDefinition, response);
            }
            finally {
                jbpmContext.close();
            }
        }
        catch (FileUploadException e) {
            response.sendError(400, e.getMessage());
        }
    }

    private void writeHeader(PrintWriter out) throws MalformedURLException {
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Process Deployment</title>");
        out.print("<link rel='stylesheet' type='text/css' href='");
        out.print(this.getServletContext().getContextPath());
        out.println("/jbpm.css'/>");
        out.println("</head>");
        out.println("<body>");
    }

    private void writeTrailer(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    private InputStream parseRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, FileUploadException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new FileUploadException("request does not carry multipart content");
        }
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator i = upload.getItemIterator(request);
        while (i.hasNext()) {
            FileItemStream part = i.next();
            if (part.isFormField()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("retrieved file " + part.getName()));
            }
            return part.openStream();
        }
        throw new FileUploadException("request contains no file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessDefinition parseProcessArchive(InputStream processStream) throws IOException {
        ZipInputStream processArchiveStream = new ZipInputStream(processStream);
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)processArchiveStream);
            if (log.isTraceEnabled()) {
                log.trace((Object)("parsed process definition " + processDefinition.getName()));
            }
            ProcessDefinition processDefinition2 = processDefinition;
            return processDefinition2;
        }
        finally {
            processArchiveStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition, HttpServletResponse response) throws IOException {
        String processName = processDefinition.getName();
        JbpmContext jbpmContext = this.jbpmConfiguration.getCurrentJbpmContext();
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
            if (log.isTraceEnabled()) {
                log.trace((Object)("deployed process definition " + processName));
            }
            PrintWriter out = response.getWriter();
            this.writeHeader(out);
            out.println("<h3>Deployment report</h3>");
            out.print("<p>Process <em>");
            out.print(processName);
            out.println("</em> was deployed successfully</p>");
            out.print("<p><a href='");
            out.print(this.getServletContext().getContextPath());
            out.println("/index.html'>Deploy another process</a></p>");
            this.writeTrailer(out);
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.error((Object)("failed to deploy process definition " + processName), (Throwable)e);
            response.sendError(500, "Failed to deploy process");
        }
    }
}

