/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jboss.bpm.console.client.model.jbpm3.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramInfo;
import org.jboss.bpm.console.server.dao.DAOFactory;
import org.jboss.bpm.console.server.dao.DiagramDAO;
import org.jboss.bpm.console.server.dao.ProcessDAO;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.util.Iterator;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
@Path("jbpm3")
public class JBPM3Management
{
   private DiagramDAO diagramDAO = null;
   private ProcessDAO processDAO = null;

   private ProcessDAO getProcessDAO(HttpServletRequest request)
   {
      if(null==this.processDAO)
      {
         DAOFactory factory = DAOFactory.newInstance(request.getSession().getServletContext());
         this.processDAO = factory.createProcessDAO();
      }

      return this.processDAO;

   }

   private DiagramDAO getDiagramDAO(HttpServletRequest request)
   {
      if(null==this.diagramDAO)
      {
         DAOFactory factory = DAOFactory.newInstance(request.getSession().getServletContext());
         this.diagramDAO = factory.createDiagramDAO();
      }

      return this.diagramDAO;

   }

   @POST
   @Path("definitions/new")
   @Produces("application/json")
   @Consumes("multipart/form-data")
   public void postNewDefinition(
     @Context
     HttpServletRequest request
   )
   {
      try
      {
         FileItemFactory factory = new DiskFileItemFactory();
         ServletFileUpload upload = new ServletFileUpload(factory);
         List items = upload.parseRequest(request);

         Iterator iter = items.iterator();
         while (iter.hasNext())
         {
            FileItem item = (FileItem) iter.next();

            if (item.isFormField())
            {
               // ignore
               System.out.println("Caught form field on file upload: " + item.getName());
            }
            else
            {
               String fieldName = item.getFieldName();
               String fileName = item.getName();
               String contentType = item.getContentType();
               boolean isInMemory = item.isInMemory();
               long sizeInBytes = item.getSize();

               // Process a file upload in memory
               byte[] data = item.get();

               getProcessDAO(request).deployNewDefinition(data);

               // Process stream
               //InputStream uploadedStream = item.getInputStream();
               //uploadedStream.close();

            }


         }
      } catch (Exception e)
      {
         throw new WebApplicationException(e);
      }

   }

   @GET
   @Path("definitions/{id}/image")
   @Produces("image/jpeg")
   public Response getProcessImage(
     @PathParam("id")
     long id,
     @Context
     HttpServletRequest request
   )
   {
      byte[] image = getDiagramDAO(request).getProcessImage(id);
      if(null==image)
         return Response.serverError().build();
      else
         return Response.ok(image).type("image/jpeg").build();
   }

   @GET
   @Path("definitions/{id}/diagramInfo")
   @Produces("application/json")
   public DiagramInfo getDiagramInfo(
     @PathParam("id")
     long id,
     @Context
     HttpServletRequest request
   )
   {
      return getDiagramDAO(request).getDiagramInfo(id);
   }

   @GET
   @Path("instances/{id}/activeNodeInfo")
   @Produces("application/json")
   public ActiveNodeInfo getActiveNodeInfo(
     @PathParam("id")
     long id,
     @Context
     HttpServletRequest request
   )
   {
      ActiveNodeInfo activNodeInfo = getDiagramDAO(request).getActivNodeInfo(id);
      return activNodeInfo;
   }

}
