/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server;

import org.jboss.bpm.console.client.model.RoleAssignment;
import org.jboss.bpm.console.client.model.RoleAssignmentWrapper;
import org.jboss.bpm.console.server.gson.GsonFactory;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import com.google.gson.Gson;

/**
 * REST server module for accessing user related data.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
@Path("user")
public class UserManagement
{

   @GET
   @Path("roles")
   @Produces("application/json")
   public Response getAssignedRoles(
     @Context
     HttpServletRequest request,
     @QueryParam("roleCheck")
     String roleCheck
     )
   {
      if(null==roleCheck)
         throw new WebApplicationException( new IllegalArgumentException("Missing parameter 'roleCheck'") );

      System.out.println("Role check user: " + request.getRemoteUser() + ", actualRoles requested: " + roleCheck);

      List<RoleAssignment> actualRoles = new ArrayList<RoleAssignment>();

      StringTokenizer tok = new StringTokenizer(roleCheck, ",");
      while(tok.hasMoreTokens())
      {
         String possibleRole = tok.nextToken();
         actualRoles.add( new RoleAssignment(possibleRole, request.isUserInRole(possibleRole)));         
      }
      return createJsonResponse( new RoleAssignmentWrapper(actualRoles));
   }

   private Response createJsonResponse(Object wrapper)
   {
      Gson gson = GsonFactory.createInstance();
      String json = gson.toJson(wrapper);
      return Response.ok(json).type("application/json").build();
   }
}
