/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.dao.internal;

import org.jboss.bpm.console.client.model.TaskReference;
import org.jboss.bpm.console.server.dao.TaskDAO;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.util.*;
import java.io.InputStream;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class JBPM3TaskDAO implements TaskDAO
{

   private JBPM3CommandDelegate delegate;

   public JBPM3TaskDAO()
   {
      this.delegate = new JBPM3CommandDelegate();
   }

   public List<TaskReference> getTasksByActors(List<String> actorList)
   {
      List<org.jbpm.taskmgmt.exe.TaskInstance> actualTasks =
            delegate.getActualTasksForActors(actorList);

      List<TaskReference> taskRefs = new ArrayList<TaskReference>();
      for(org.jbpm.taskmgmt.exe.TaskInstance t0 : actualTasks)
      {
         taskRefs.add( Transform.taskInstance(t0));
      }

      return taskRefs;
   }

   // TODO: If not requred please remove
   public List<TaskReference> getTasksByInstanceId(long instanceId)
   {
      throw new RuntimeException("Not implemented");
   }

   public Map<String, String> getAvailableTaskForms(long processId)
   {
      org.jbpm.graph.def.ProcessDefinition processDefinition =
                  delegate.getActualDefinition(processId);

      return getTask2FileMapping(processDefinition);
   }

   private Map<String, String> getTask2FileMapping(ProcessDefinition processDefinition)
   {
      Map<String, String> result = new HashMap<String, String>();

      final FileDefinition fileDefinition = processDefinition.getFileDefinition();
      if (! fileDefinition.hasFile("forms.xml"))
      {
         // exit with empty list
         // TODO: maybe an exception is better?
         return result;
      }

      final InputStream inputStream = fileDefinition.getInputStream("forms.xml");
      if (inputStream == null)
      {
         throw new RuntimeException("Failed to open stream on forms.xml");
      }

      final Document document = XmlUtil.parseXmlInputStream(inputStream);
      final Element documentElement = document.getDocumentElement();
      final NodeList nodeList = documentElement.getElementsByTagName("form");
      final int length = nodeList.getLength();
      for (int i = 0; i < length; i ++)
      {
         final Element element = (Element) nodeList.item(i);
         final String itemTaskName = element.getAttribute("task");
         final String itemFormName = element.getAttribute("form");
         if (itemTaskName == null || itemFormName == null) {
            continue;
         }
         result.put(itemTaskName, itemFormName);
      }
      return result;
   }

   public byte[] getTaskFormByTaskName(long processId, long taskId)
   {
      org.jbpm.graph.def.ProcessDefinition processDefinition =
                       delegate.getActualDefinition(processId);
      org.jbpm.taskmgmt.exe.TaskInstance t0 = delegate.getTaskById(taskId);

      Map<String,String> fileMapping = getTask2FileMapping(processDefinition);
      String fileName = fileMapping.get(t0.getName());
      if(fileName !=null)
         return processDefinition.getFileDefinition().getBytes(fileName);
      else
         throw new RuntimeException("No form definition for taskId '"+taskId+"'");
      
   }
}
