/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.jbpm3;

import org.jboss.bpm.console.client.model.jbpm3.DiagramInfo;
import org.jboss.bpm.console.client.model.jbpm3.DiagramNodeInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class DiagramInfoParser
{
   /**
    * Will close the stream after successfull read
    * @param in
    * @return
    */
   public static DiagramInfo parse(InputStream in )
   {
      Document document = XmlUtil.parseXmlInputStream(in);
      Element processDiagramElement = document.getDocumentElement();
      final String widthString = processDiagramElement.getAttribute("width");
      final String heightString = processDiagramElement.getAttribute("height");
      final List<DiagramNodeInfo> diagramNodeInfoList = new ArrayList<DiagramNodeInfo>();
      final NodeList nodeNodeList = processDiagramElement.getElementsByTagName("node");
      final int nodeNodeListLength = nodeNodeList.getLength();
      for (int i = 0; i < nodeNodeListLength; i ++) {
         final Node nodeNode = nodeNodeList.item(i);
         if (nodeNode instanceof Node && nodeNode.getParentNode() == processDiagramElement) {
            final Element nodeElement = (Element) nodeNode;
            final String nodeName = nodeElement.getAttribute("name");
            final String nodeXString = nodeElement.getAttribute("x");
            final String nodeYString = nodeElement.getAttribute("y");
            final String nodeWidthString = nodeElement.getAttribute("width");
            final String nodeHeightString = nodeElement.getAttribute("height");
            final DiagramNodeInfo nodeInfo = new DiagramNodeInfo(
              nodeName,
              Integer.parseInt(nodeXString),
              Integer.parseInt(nodeYString),
              Integer.parseInt(nodeWidthString),
              Integer.parseInt(nodeHeightString)
            );
            diagramNodeInfoList.add(nodeInfo);
         }
      }
      DiagramInfo diagramInfo = new DiagramInfo(
        Integer.parseInt(heightString),
        Integer.parseInt(widthString),
        diagramNodeInfoList
      );

      try
      {
         in.close();
      } catch (IOException e)
      {
         throw new RuntimeException("Failed to close stream", e);
      }

      return diagramInfo;
   }
}
