/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.server.integration.spec;

import org.jboss.bpm.console.server.integration.ExtensionManagement;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jboss.bpm.console.server.integration.TaskManagement;
import org.jboss.bpm.console.server.integration.UserManagement;
import org.jboss.bpm.console.server.integration.jbpm3.JBPM3InvocationProxy;
import org.jboss.bpm.console.server.integration.jbpm3.JBPM3ManagementExtension;
import org.jboss.bpm.console.server.integration.jbpm3.JBPM3ProcessManagement;
import org.jboss.bpm.console.server.integration.jbpm3.JBPM3TaskManagement;
import org.jboss.bpm.console.server.integration.jbpm3.JBPM3UserManagement;

/**
 * Toggle the spec integration through:
 * <code>
 * -Dorg.jboss.bpm.console.server.integration.ManagementFactory.spec=true
 * </code>
 * @author Thomas.Diesler@jboss.com
 */
public class ManagementFactoryImpl extends ManagementFactory
{
  private boolean useSpecIntegration = true;
  
  public ProcessManagement createProcessManagement()
  {
    if (useSpecIntegration)
    {
      return (ProcessManagement)InvocationProxy.newInstance(new ProcessManagementImpl());
    }
    else
    {
      return (ProcessManagement)JBPM3InvocationProxy.newInstance(new JBPM3ProcessManagement());
    }
  }

  public TaskManagement createTaskManagement()
  {
    /*if (useSpecIntegration)
    {
      return (TaskManagement)InvocationProxy.newInstance(new TaskManagementImpl());
    }
    else
    {
      return (TaskManagement)JBPM3InvocationProxy.newInstance(new JBPM3TaskManagement());
    }
    */

    return (TaskManagement)JBPM3InvocationProxy.newInstance(new JBPM3TaskManagement());
  }

  public UserManagement createUserManagement()
  {
    if (useSpecIntegration)
    {
      return (UserManagement)InvocationProxy.newInstance(new UserManagementImpl());
    }
    else
    {
      return (UserManagement)JBPM3InvocationProxy.newInstance(new JBPM3UserManagement());
    }
  }

  public ExtensionManagement createExtensionManagement()
  {
    return (ExtensionManagement)JBPM3InvocationProxy.newInstance(new JBPM3ManagementExtension());
  }
}
